#include <string> 
#include <iostream> 

#pragma warning(disable: 4996)
#pragma warning(disable: 4345)

#include <boost/signals2.hpp> 
#include <boost/shared_ptr.hpp> 
#include <boost/make_shared.hpp> 


struct MySlot {
	void handler(std::string message) const {
		std::cout << message << std::endl;
	}
};

void main(void) {
	boost::signals2::signal<void(std::string)> emit;
	boost::shared_ptr<MySlot> h = boost::make_shared<MySlot>(); 
	boost::signals2::slot<void(std::string)> recv(&MySlot::handler, h.get(), _1);
	emit.connect(recv.track(h));
	emit("slot wurde explizit verwendet");
}
