# 20120123/pb@bieringer.de: adjustments for use with prefix distributed by DHCPv6

BEGIN {
    srand();
    # Datenbank
    alltime="/tmp/prefix.log";  
    # HINWEIS: Die folgenden zwei Variablen muessen an
    # die eigenen Vorgaben angepasst werden
    interface="lan";
    reserved="01";
    # Vorgaben, koennen angepasst werden!
    # absolute Gueltigkeit: 7 Tage
    AdvValidLifetime=604800;
    # bevorzugte Gueltigkeit: 24 Stunden
    AdvPreferredLifeTime=86400;
   
    # Initialization on first run
    system("/bin/touch " alltime);
    
    # define interface bridge
    interface_br="br-" interface;
    printf("%-6s: %-20s: %s\n", "DEBUG", "Bridge interface", interface_br);
    
    # get SLA length
    "uci get dhcp6c." interface ".sla_len" | getline sla_len;
    printf("%-6s: %-20s: %d\n", "DEBUG", "SLA length on " interface, sla_len);
    
    # get address of interface
    cmd="cat /proc/net/if_inet6";
    while ((cmd | getline) >0) 
    {
    	if ($6 == interface_br) {
    		if ($4 == "00") {
		    	address=$1;
		    	break;
	    };
    	};
    }
    close(cmd);
    
    if (address == "") {
 	   printf("%-6s: %-20s: %s\n", "ERROR", "can't retrieve IPv6 address", interface);
   	exit 1; 
    };
    
    printf("%-6s: %s %s: %s\n", "DEBUG", "IPv6 address of interface", interface, address);
    
    # generate a random subnet
    do {
	gensubnet(sla_len);
    } while (find_in_alltime(full_prefix) == 0)
    
    tla_cl=substr(address,1,(64 - sla_len) / 4);
    sla_cl=subnet;
    printf("%-6s: %-20s: %s\n", "DEBUG", "TLA(colon-less)", tla_cl);
    printf("%-6s: %-20s: %s\n", "DEBUG", "SLA(colon-less)", sla_cl);
    prefix_cl=tla_cl sla_cl;
    printf("%-6s: %-20s: %s\n", "DEBUG", "Prefix(colon-less)", prefix_cl);
    
    # Generate IPv6 address notation
    for(i=0; i<4; i++) {
   	prefix=prefix substr(prefix_cl,i*4 + 1,4) ":"; 
    };
    
    printf("%-6s: %-20s: %s\n", "DEBUG", "Prefix", prefix);
    
    full_prefix=prefix ":/64";
    router_addr=prefix ":1/64";

    printf("%-6s: %-20s: %s\n", "DEBUG", "full_prefix", full_prefix);
    printf("%-6s: %-20s: %s\n", "DEBUG", "router_addr", router_addr);
    
    set_newprefix(full_prefix,AdvValidLifetime,AdvPreferredLifeTime);
    setgwaddr(router_addr, AdvValidLifetime*2, AdvPreferredLifeTime*2);
    system("/etc/init.d/radvd reload");
    printf("%s;%s;%s;%s;%s\n", full_prefix, router_addr, gentime, endtime, AdvValidLifetime) >> alltime;
    exit;
}

function find_in_alltime(full_prefix)
{
    FS=";";
    erg=1;    
    while ((getline line < alltime) > 0) 
    {
		split(line, data, ";")
		if ( data[1] == full_prefix ) {
			if ( data[3] > systime() - (3*AdvValidLifetime)) {
			erg=0;
			} 
		} 
    } 
    close(alltime);
    return erg;
}

function gensubnet(len) {
    printf("%-6s: %s: %x\n", "DEBUG", "Call gensubnet with length: ", len);
    formatstring=sprintf("%%0%dx", len / 4);
    do {
	subnet=sprintf(formatstring, int((2**len)*rand()));
    } while(subnet == reserved) 
    gentime=systime();
    return;
}

function setgwaddr(addr, gw_valid_lft, gw_preferred_lft) {
    if (system("/usr/sbin/ip -6 addr add " addr " dev " interface_br " valid_lft " gw_valid_lft " preferred_lft " gw_preferred_lft)!=0) 
	print "Error: Can't set gateway address " addr
}

function set_newprefix(nprefix,AdvValidLifetime,AdvPreferredLifeTime) {
    status = system("uci show radvd.@prefix[1]");
    if (status != 0) {
	printf("%-6s: %-20s: %s\n", "DEBUG", "setup config", "1");
	system("/sbin/uci add radvd prefix");
 	system("/sbin/uci set radvd.@prefix[1].interface=" interface);
 	system("/sbin/uci set radvd.@prefix[1].ignore=0");
 	system("/sbin/uci set radvd.@prefix[1].AdvRouterAddr=0");
 	system("/sbin/uci set radvd.@prefix[1].AdvAutonomous=1");
 	system("/sbin/uci set radvd.@prefix[1].AdvOnLink=1");
    };
    system("/sbin/uci set radvd.@prefix[1].prefix=" nprefix);
    system("/sbin/uci set radvd.@prefix[1].AdvValidLifetime=" AdvValidLifetime);
    system("/sbin/uci set radvd.@prefix[1].AdvPreferredLifetime=" AdvPreferredLifeTime);
    system("/sbin/uci commit radvd");
}