import clr
from sho import *
from System import *

class RandomDelegate:
  def __init__(self, N = 10000):
    self.result = DoubleArray(N)
    seed = System.DateTime.Now.Millisecond
    self.gen = System.Random(seed)

  def run(self):
      self.result.FillRandom(self.gen)
      self.mean = self.result.Mean()
      self.sum = self.result.Sum()

def main():
  rng = []
  thr = []
  N = System.Environment.ProcessorCount
  for i in xrange(N):
    f = RandomDelegate()
    rng.append(f)
    t = ShoThread(f.run, "RNG thread #%d" % (i))
    t.Start()
    thr.append(t)

  # zwischenzeitlich etwas anderes tun ...
  # ... dann auf Ende der Threads warten
  for i in xrange(N):
    thr[i].Join()
    print rng[i].mean, rng[i].sum / rng[i].result.Count

if __name__ == 'shoconsole':
  main()
