package com.linkesoft.sensors;

import java.util.List;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

public class MainActivity extends Activity implements SensorEventListener {
	private SensorManager sensorManager;
	private SensorView sensorView;
	private Spinner sensorSelectorSpinner;

	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        sensorView=(SensorView)findViewById(R.id.sensorView);
        sensorSelectorSpinner = (Spinner) findViewById(R.id.sensorSelectorSpinner);

        setupSensorSelector();     
    }
    @Override
	protected void onResume() {
        super.onResume();
        Sensor sensor=(Sensor) sensorSelectorSpinner.getSelectedItem();
        sensorManager.registerListener(this, sensor, SensorManager.SENSOR_DELAY_GAME);
        sensorView.reset();
    }

    @Override
	protected void onPause() {
        super.onPause();
        sensorManager.unregisterListener(this); // unregister listener for all sensors
    }
	public void onAccuracyChanged(Sensor sensor, int accuracy) {		
	}
	public void onSensorChanged(SensorEvent event) {
		sensorView.setSensorEvent(event);		
	}

	
	private void setupSensorSelector()
	{
        // Sensor-Auswahl
        sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        List<Sensor> sensorList = sensorManager.getSensorList(Sensor.TYPE_ALL);
        for(Sensor sensor: sensorList)
        	Log.v("Sensor",sensor.getName());
        ArrayAdapter<Sensor> adapter = new ArrayAdapter<Sensor>(this,
                android.R.layout.simple_spinner_item,sensorList) {
        	@Override
        	public View getView(int position, View convertView, ViewGroup parent) {
    			if (null == convertView) {
	                LayoutInflater vi = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);	
	                convertView = vi.inflate(android.R.layout.simple_spinner_item, null);
    			}
        		Sensor sensor=getItem(position);
				TextView text=(TextView) convertView.findViewById(android.R.id.text1);
				text.setText(sensor.getName());
				return convertView;
        	}
        	@Override
			public View getDropDownView(int position, View convertView, ViewGroup parent) {
    			if (null == convertView) {
	                LayoutInflater vi = (LayoutInflater)getSystemService(Context.LAYOUT_INFLATER_SERVICE);	
	                convertView = vi.inflate(android.R.layout.simple_spinner_dropdown_item, null);
    			}
        		Sensor sensor=getItem(position);
				TextView text=(TextView) convertView.findViewById(android.R.id.text1);
				text.setText(sensor.getName());
				return convertView;
        	}
        };
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        sensorSelectorSpinner.setAdapter(adapter);
        sensorSelectorSpinner.setPrompt(getString(R.string.SelectSensor));
        sensorSelectorSpinner.setOnItemSelectedListener(new OnItemSelectedListener()
        {

			public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
		        sensorManager.unregisterListener(MainActivity.this); // unregister listener for all sensors
		        Sensor sensor=(Sensor) sensorSelectorSpinner.getSelectedItem();
		        sensorManager.registerListener(MainActivity.this, sensor, SensorManager.SENSOR_DELAY_GAME);
		        sensorView.reset();
			}

			public void onNothingSelected(AdapterView<?> parent) {				
			}
        	
        });
	}
}