package com.linkesoft.eierlaufen;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;

public class EggView extends View {
	private final Bitmap bitmap;
	// Winkel und Verschiebung des Eis gegenber dem Zentrum 
	private float phi; // rad
	private float dx,dy; // m
	

	
	public interface FailureHandler {
		public void onFailure();
	}
	public FailureHandler failureHandler;

	public EggView(Context context, AttributeSet attrs) {
		super(context, attrs);
		bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.egg);
	}
	
	@Override
	protected void onDraw(Canvas canvas) {
		// schwarzer Hintergrund
		Paint pBackground=new Paint();
		pBackground.setColor(Color.BLACK);
		canvas.drawPaint(pBackground);
		// skaliere, rotiere und verschiebe Eier-Bitmap
		// skaliert so dass das Ei komplett auf den Bildschirm passt
		Matrix matrix=new Matrix();
		float scale=getWidth()/(float)bitmap.getWidth();
		if(bitmap.getHeight()*scale>getHeight())
			scale=getHeight()/(float)bitmap.getHeight(); // fit on screen
		matrix.postScale(scale,scale);
		matrix.postTranslate(-getWidth()/2f,-getHeight()/2f); // Eimittelpunkt im Zentrum
		// Drehung (in Grad)
		matrix.postRotate((float)(phi/Math.PI*180));
		matrix.postTranslate(getWidth()/2f,getHeight()/2f); // Eimittelpunkt zurck
		// zentriert und um dx verschoben
		float dxPixels=meters2pixels(dx);
		float dyPixels=meters2pixels(dy);
		matrix.postTranslate((float)(dxPixels+(getWidth()-bitmap.getWidth()*scale)/2.0), dyPixels+(float)((getHeight()-bitmap.getHeight()*scale)/2.0));		
		// und zeichne Bitmap
		canvas.drawBitmap(bitmap, matrix,null);	
		// ist das Ei aus dem Bildschirm gelaufen?
		if(Math.abs(dxPixels)>getWidth()/2f||Math.abs(dyPixels)>getHeight()/2f)
		{
			Log.v("EggView","Egg off-screen");
			if(failureHandler!=null)
				failureHandler.onFailure();
		}
		// zu weit verdreht
		if(Math.abs(phi)>Math.PI/4)
		{
			Log.v("EggView","Egg rotated too much");
			if(failureHandler!=null)
				failureHandler.onFailure();
		}

	}
	
	private float meters2pixels(float meters)
	{
		Resources resources = getResources();
		return TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_MM, meters*1000.0f, resources.getDisplayMetrics());
	}

	public void setCoordinates(float dx, float dy, float phi) {
		//Log.v("EggView","dx="+dx+" dy="+dy+" phi="+phi);
		this.dx=dx;
		this.dy=dy;
		this.phi=phi;
		invalidate();
		
	}
}
