// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: videowidget.cpp 64d6eac363e2 2011/09/30 12:24:19 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include <QPainter>
#include <QPainterPath>
#include "videowidget.h"
#include "nui.h"

VideoWidget::VideoWidget(QWidget* parent) : QWidget(parent)
        , mShowSilhouette(false)
{
    setMinimumSize(320, 240);
    setMaximumSize(320, 240);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);
}


void VideoWidget::paintEvent(QPaintEvent*)
{
    if (mFrame.isNull())
        return;
    QPainter painter(this);
    painter.drawImage(rect(), mFrame);
    painter.setRenderHint(QPainter::NonCosmeticDefaultPen);
    for (SkeletonList::const_iterator i = mSkeletons.constBegin(); i != mSkeletons.constEnd(); ++i) {
        const Skeleton& skeleton = *i;
        painter.setPen(Qt::NoPen);
        painter.setBrush(QColor(170, 240, 65, 0xc0));
        for (Skeleton::const_iterator p = skeleton.constBegin(); p != skeleton.constEnd(); ++p) {
            const int r = (p->state() == NUI_SKELETON_POSITION_TRACKED)? 3 : 2;
            painter.drawRect(p->x()-r, p->y()-r, r*2, r*2);
        }
    }
    if (mShowSilhouette) {
        painter.setBrush(QBrush(QColor(255,128,0, 40)));
        painter.setPen(QPen(QBrush(QColor(255, 128, 0)), 2.6));
        QPainterPath path;
        painter.drawRect(120, 3, 80, 232);
        painter.drawPath(path);
    }
}


void VideoWidget::setFrame(const QImage& frame)
{
    mFrame = frame;
    update();
}


void VideoWidget::setSkeletons(const SkeletonList& skeletons)
{
    mSkeletons = skeletons;
    for (SkeletonList::iterator skel = mSkeletons.begin(); skel != mSkeletons.end(); ++skel) {
        for (Skeleton::iterator point = skel->begin(); point != skel->end(); ++point) {
            LONG x, y;
            NuiImageGetColorPixelCoordinatesFromDepthPixel(NUI_IMAGE_RESOLUTION_640x480, NULL, point->x()*320, point->y()*240, point->z(), &x, &y);
            point->setX(x*width()/640);
            point->setY(y*height()/480);
        }
    }
    update();
}


void VideoWidget::showSilhouette(bool enabled)
{
    mShowSilhouette = enabled;
    update();
}
