// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: skeleton.cpp f9a43276afac 2011/11/03 10:35:31 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include "skeleton.h"
#include "vector.h"

#include <QtCore/QtDebug>


bool Skeleton::handAboveElbow(FlagSemaphore::Side side) const {
    static const float Threshold = 0.1f;
    float distOfHandAboveElbow = 0;
    switch (side) {
    case FlagSemaphore::RIGHT:
        distOfHandAboveElbow = this->at(NUI_SKELETON_POSITION_HAND_RIGHT).y() - this->at(NUI_SKELETON_POSITION_ELBOW_RIGHT).y();
        break;
    case FlagSemaphore::LEFT:
        distOfHandAboveElbow = this->at(NUI_SKELETON_POSITION_HAND_LEFT).y() - this->at(NUI_SKELETON_POSITION_ELBOW_LEFT).y();
        break;
    default:
        break;
    }
    return distOfHandAboveElbow > Threshold;
}


static bool checkAngle(float angle, int direction)
{
    static const float EPSILON = 15.0f;
    switch (direction) {
    case FlagSemaphore::UP:
        return angle > 140;
    case FlagSemaphore::SIDE_UP:
        return fabs(angle - 120) < EPSILON;
    case FlagSemaphore::SIDE:
        return fabs(angle - 90) < EPSILON;
    case FlagSemaphore::SIDE_DOWN:
        return fabs(angle - 45) < EPSILON;
    case FlagSemaphore::DOWN:
        return angle < 22;
    }
    return false;
}


bool Skeleton::armPoints(FlagSemaphore::Side side, int direction, __OUT float* angle) const
{
    bool rc = false;
    const bool otherSide = (direction & FlagSemaphore::OTHER) == FlagSemaphore::OTHER;
    direction &= ~FlagSemaphore::OTHER;
    const Vector trunk(this->at(NUI_SKELETON_POSITION_SHOULDER_CENTER), this->at(NUI_SKELETON_POSITION_SPINE));
    switch (side) {
    case FlagSemaphore::LEFT: {
            const Point& hand =this-> at(NUI_SKELETON_POSITION_HAND_LEFT);
            const Point& shoulder = this->at(NUI_SKELETON_POSITION_SHOULDER_LEFT);
            const Vector arm(shoulder, hand);
            const float leftHandAngle = rad2deg(arm.angleTo(trunk));
            if (angle != NULL)
                *angle = leftHandAngle;
            rc = checkAngle(leftHandAngle, direction);
            if (otherSide) // dumb solution, works only if face points to camera
                rc = rc && hand.x() > shoulder.x();
        }
        break;
    case FlagSemaphore::RIGHT: {
            const Point& hand = this->at(NUI_SKELETON_POSITION_HAND_RIGHT);
            const Point& shoulder = this->at(NUI_SKELETON_POSITION_SHOULDER_RIGHT);
            const Vector arm(shoulder, hand);
            const float rightHandAngle = rad2deg(arm.angleTo(trunk));
            rc = checkAngle(rightHandAngle, direction);
            if (angle != NULL)
                *angle = rightHandAngle;
            if (otherSide) // dumb solution, works only if face points to camera
                rc = rc && hand.x() < shoulder.x();
        }
        break;
    }
    return rc;
}

