// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: nuithread.cpp cc7755353453 2011/10/21 07:45:01 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include "nuithread.h"


NUIThread::NUIThread(QObject* parent) : QThread(parent)
{
    mNUI = NUI::instance();

    mNextVideoFrameEvent = CreateEvent(NULL, TRUE,  FALSE, NULL);
    mVideoStreamHandle = mNUI->openStream(NUI_IMAGE_TYPE_COLOR, NUI_IMAGE_RESOLUTION_640x480, mNextVideoFrameEvent);

    mNextDepthFrameEvent = CreateEvent(NULL, TRUE,  FALSE, NULL);
    mDepthStreamHandle = mNUI->openStream(NUI_IMAGE_TYPE_DEPTH_AND_PLAYER_INDEX, NUI_IMAGE_RESOLUTION_320x240, mNextDepthFrameEvent);

    mNextSkeletonEvent   = CreateEvent(NULL, TRUE,  FALSE, NULL);
    mNUI->enableTracking(mNextSkeletonEvent);

    mEvNuiProcessStop    = CreateEvent(NULL, FALSE, FALSE, NULL);
}


NUIThread::~NUIThread()
{
    halt();
}


void NUIThread::halt(void)
{
    if (mEvNuiProcessStop) {
        SetEvent(mEvNuiProcessStop);
        wait();
        CloseHandle(mEvNuiProcessStop);
    }
}


void NUIThread::depthAlertReceived(void)
{
    QImage img = mNUI->getStreamDepthFrame(mDepthStreamHandle);
    if (!img.isNull())
        emit depthFrameReady(img);
    ResetEvent(mNextDepthFrameEvent);
}


void NUIThread::videoAlertReceived(void)
{
    QImage img = mNUI->getStreamVideoFrame(mVideoStreamHandle);
    if (!img.isNull())
        emit videoFrameReady(img);
    ResetEvent(mNextVideoFrameEvent);
}


void NUIThread::skeletonAlertReceived(void)
{
    SkeletonList skeletons;
    SkeletonList skeletonsOnImage;
    mNUI->getSkeletons(skeletons, skeletonsOnImage);
    if (skeletons.size() > 0)
        emit skeletonsReady(skeletons, skeletonsOnImage);
    ResetEvent(mNextSkeletonEvent);
}


void NUIThread::run(void)
{
    static const DWORD EventCount = 4;
    const HANDLE hEvent[EventCount] = {
        mEvNuiProcessStop,    // 0
        mNextDepthFrameEvent, // 1
        mNextVideoFrameEvent, // 2
        mNextSkeletonEvent    // 3
    };
    forever {
        const DWORD eIdx = WaitForMultipleObjects(EventCount, hEvent, FALSE, 100);
        switch (eIdx) {
        case 0: return;
        case 1: depthAlertReceived(); continue;
        case 2: videoAlertReceived(); continue;
        case 3: skeletonAlertReceived(); continue;
        }
    }
}
