// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: depthimagewidget.h b68c3a3f78e5 2011/08/18 11:38:28 Oliver Lau <oliver@von-und-fuer-lau.de> $

#ifndef __DEPTHIMAGEWIDGET_H_
#define __DEPTHIMAGEWIDGET_H_

#include <QWidget>
#include <QImage>
#include "nui.h"

class DepthImageWidget : public QWidget
{
    Q_OBJECT
public:
    explicit DepthImageWidget(QWidget* parent = NULL);
    QSize minimumSizeHint(void) const { return QSize(320, 240); }
    QSize sizeHint(void) const { return QSize(320, 240); }

protected:
    void paintEvent(QPaintEvent*);

private:
    QImage mFrame;
    SkeletonList mSkeletons;

public slots:
    void setFrame(const QImage&);
    void setSkeletons(const SkeletonList&);

};

#endif // __DEPTHIMAGEWIDGET_H_
