// Copyright (c) 2011 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: depthimagewidget.cpp 3f9b1d5b2698 2011/08/19 11:46:10 Oliver Lau <oliver@von-und-fuer-lau.de> $

#include <QPainter>
#include "depthimagewidget.h"


DepthImageWidget::DepthImageWidget(QWidget* parent) :
    QWidget(parent)
{
    setMinimumSize(320, 240);
    setMaximumSize(320, 240);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);
}


void DepthImageWidget::paintEvent(QPaintEvent*)
{
    if (mFrame.isNull())
        return;
    QPainter painter(this);
    painter.drawImage(rect(), mFrame);
    painter.setRenderHint(QPainter::Antialiasing);
    painter.setPen(Qt::NoPen);
    static const int r = 3;
    static const int r2 = 5;
    for (SkeletonList::const_iterator i = mSkeletons.constBegin(); i != mSkeletons.constEnd(); ++i) {
        const Skeleton& skeleton = *i;
        for (int j = 0; j < skeleton.size(); ++j) {
            const QColor& c = NUI::JointColorTable[j];
            const Point& p = skeleton[j];
            painter.setPen(Qt::NoPen);
            painter.setBrush(c);
            painter.drawEllipse(p.x()*width()-r, p.y()*height()-r, r*2, r*2);
            if (p.state() == NUI_SKELETON_POSITION_TRACKED) {
                painter.setBrush(Qt::NoBrush);
                painter.setPen(c);
                painter.drawEllipse(p.x()*width()-r2, p.y()*height()-r2, r2*2, r2*2);
            }
        }
    }
}


void DepthImageWidget::setFrame(const QImage& frame)
{
    mFrame = frame;
    update();
}


void DepthImageWidget::setSkeletons(const SkeletonList& skeletons)
{
    mSkeletons = skeletons;
    update();
}
