#include "WaitforMOClass.h"


DWORD WINAPI WThread(LPVOID pParameter) {
// The Waitthread
    PWTHREADDATA pData = ( PWTHREADDATA )pParameter;

    pData->Status= 0;
	if ((pData->Magic !=MAGIC) || ((pData->Count) >MAXIMUM_WAIT_OBJECTS)) {
		fprintf (stderr,"oh dear, ThreadInformation not valid\n"); 
		return WAIT_NOTVALID;
	}
    pData->Status = WaitForMultipleObjects(
                        pData->Count,
						pData->pHandles,
                        pData->WaitAll,
                        pData->Milliseconds );

	
 return pData->Status;

}


CWait::CWait(WAITTYPE aWaitType, int aMaxObjects) {
	DWORD WThreadId;
	WaitType=aWaitType;
	MaxObjects=aMaxObjects;

	Maximum_Wait_Objects=MAXIMUM_WAIT_OBJECTSEX;
	hTerminateEvent=0;
	if (WaitType==WAITANYTHREADS) {
		Maximum_Wait_Objects--; // minus one for the Event Handle 
		hTerminateEvent=CreateEvent(NULL,TRUE,FALSE,NULL);
		if (0==hTerminateEvent) {CreateResult=FALSE; return; } 		
	}

	WThreadCount=MaxObjects/Maximum_Wait_Objects; 
	LastObjCount=MaxObjects % Maximum_Wait_Objects;
	if (LastObjCount>0) WThreadCount++; 
	if (WaitType !=WAITALLSEQUENTIAL) { // do I need WaitThreads?

		//Table of Handles for Waitthreads:
		pWHandles=   (PHANDLE) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY | HEAP_GENERATE_EXCEPTIONS,
			WThreadCount*sizeof(HANDLE));
		if (NULL==pWHandles) {CreateResult=FALSE; return; } 
		//Table of ThreadData
		pWThreadData = (PWTHREADDATA) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY | HEAP_GENERATE_EXCEPTIONS, 
			WThreadCount*sizeof(WTHREADDATA));
		if (NULL==pWHandles) {CreateResult=FALSE; return; } 
		for (int t=0; t < WThreadCount; t++) {

			pWThreadData[t].Count=Maximum_Wait_Objects;
			if ((LastObjCount >0 )&& (t==WThreadCount-1)) pWThreadData->Count=LastObjCount;

			// just in case a Magic to check consistency 
			pWThreadData[t].Magic=MAGIC;
			pWThreadData[t].nr=t;						
			pWHandles[t] = CreateThread( 
				NULL,                   // default security attributes
				0,                      // use default stack size  
				WThread,                // thread function name
				&pWThreadData[t],       // argument to thread function 
				CREATE_SUSPENDED,       // create in suspended Mode  
				&WThreadId);            // but thread identifier not used
			if (NULL==pWHandles[t]) { CreateResult=FALSE; return;}   // oh dear, something went wrong
		}
	}
	CreateResult=TRUE;
};

CWait::~CWait() { 
	if (WAITALLSEQUENTIAL==WaitType) return; // nothing to do here
	if (0!= hTerminateEvent) CloseHandle(hTerminateEvent);  

	//close all WaitThreadHandles and free table of WaitThreadHandles
	if (NULL != pWHandles) { 
		for (int t=0; t<WThreadCount; t++) {
			if (NULL!=pWHandles [t])  CloseHandle(pWHandles[t]);
		}
		HeapFree(GetProcessHeap(),0,pWHandles);
	}
   if (NULL != pWThreadData) HeapFree (GetProcessHeap(),0,pWThreadData); 
};



DWORD CWait::GetWaitAllStatus( __in DWORD   WStatus ) {


	DWORD Status;
	DWORD OStatus;

	if (WStatus != WAIT_OBJECT_0) return WAIT_RAISE_EXCEPTION; //unexpected result  
	/*
	ok all wthreads terminated without error of the wthreads 
	but maybe with errors in any objects  
	so get their exit codes, and calculate Status  
	*/

	for (int t=0; t<WThreadCount; t++) {
		if (!GetExitCodeThread(pWHandles[ t ],&OStatus)) return WAIT_RAISE_EXCEPTION;
		Status=WAIT_OBJECTEX_0;        // the expected case 
		if (OStatus !=WAIT_OBJECT_0){  // but maybe something different has happened
			switch (OStatus) {
				case STILL_ACTIVE: return WAIT_RAISE_EXCEPTION;    // thread still running? why that
				case WAIT_FAILED:	Status=WAIT_FAILED; break;
				case WAIT_NOTVALID: Status=WAIT_FAILED; break;
				case WAIT_ABANDONED_0: if (Status < WAIT_FAILED) Status=WAIT_ABANDONEDEX_0; break;
				case WAIT_TIMEOUT: if (Status < WAIT_ABANDONEDEX_0) Status=WAIT_TIMEOUTEX; break; 
				default: return WAIT_RAISE_EXCEPTION; //in mysterious situations; 
				}
		}
	}
	return Status; 
}

DWORD CWait::GetWaitAnyStatus(__in DWORD   WStatus) {

	 int t,Wt; 
	 DWORD Status;
	 DWORD OStatus;

	 Status=WAIT_RAISE_EXCEPTION; // worst case assumption
	 if ((WStatus < WAIT_OBJECT_0) || (WStatus >= WAIT_ABANDONED_0)) return WAIT_RAISE_EXCEPTION; // unexpected result 
	 Wt=WStatus-WAIT_OBJECT_0; // wt is the handle index of the WThread with the first signaling object
	 if (!GetExitCodeThread(pWHandles[ Wt ],&OStatus)) return WAIT_RAISE_EXCEPTION; 

	 if ((OStatus>= WAIT_OBJECT_0) && (OStatus<WAIT_ABANDONED_0))         // all ok, callculate handle index  
		 Status=WAIT_OBJECTEX_0+Wt*(MAXIMUM_WAIT_OBJECTSEX-1)+(OStatus-WAIT_OBJECT_0); 
	 else if ((OStatus >=WAIT_ABANDONED_0)&& (OStatus < WAIT_ABANDONED_0+ (MAXIMUM_WAIT_OBJECTSEX-1)))  // aband. Mutex
		 Status=WAIT_ABANDONEDEX_0+Wt*(MAXIMUM_WAIT_OBJECTSEX-1)+(OStatus-WAIT_ABANDONED_0);
	 else if (OStatus==WAIT_TIMEOUT) Status=WAIT_TIMEOUTEX; // should only occur if Millisecs != INFINITE 
	 else if (OStatus==WAIT_FAILED) Status=WAIT_FAILED;     

	 // Wait for Termination of the other WThreads if timout is set, adjust status if signal or error is found 
     
	 if (Status==WAIT_TIMEOUTEX) { 
		 for (t=0; t<WThreadCount ;t++) if (t != Wt) {
			 WStatus=WaitForSingleObject(pWHandles[t],INFINITE);
			 if (WStatus != WAIT_OBJECT_0) Status= WAIT_RAISE_EXCEPTION; 
			 else { 
				 if (!GetExitCodeThread(pWHandles[ t ],&OStatus)) Status= WAIT_RAISE_EXCEPTION;
				 else {
					 if (OStatus != WAIT_TIMEOUT) { // timeout expected, but you never know
						 if ((OStatus >= WAIT_OBJECT_0) && (OStatus<WAIT_ABANDONED_0)) {  
							 if (Status==WAIT_TIMEOUTEX) Status=WAIT_OBJECTEX_0+(t-WAIT_OBJECT_0)*(MAXIMUM_WAIT_OBJECTSEX-1); }
						 else if ((OStatus >=WAIT_ABANDONED_0)&& (OStatus < WAIT_ABANDONED_0+ (MAXIMUM_WAIT_OBJECTSEX-1))) { // aband. Mutex
							 if ((Status<WAIT_ABANDONEDEX_0) || (Status==WAIT_TIMEOUTEX)) Status=WAIT_ABANDONEDEX_0+(Wt-WAIT_ABANDONED_0)*(MAXIMUM_WAIT_OBJECTSEX-1);} 
						 else if (OStatus==WAIT_FAILED) Status=WAIT_FAILED;
						 else Status= WAIT_RAISE_EXCEPTION;
					 }
				 }
			 }
		 }
	 }
	 return Status;
}
DWORD   CWait::TerminateWaitByEvent (int ExcludeThread) {
	     DWORD WStatus;

         if (!SetEvent(hTerminateEvent)) return WAIT_RAISE_EXCEPTION;

		 for (int t=0; t < WThreadCount;t++) if (t!=ExcludeThread) {
			WStatus=WaitForSingleObject(pWHandles[t],INFINITE);        
			//wait until all Threads are terminated (or have errors, which are ignored here)
		 }
		 ResetEvent(hTerminateEvent);  
		 return 0;
}

DWORD  CWait::GetCreateResult() {
return CreateResult;
}

DWORD CWait::WaitForManyObjects(
								__in  DWORD Count,
								__in  const PHANDLE pHandles,
								__in  BOOL WaitAll,
								__in  DWORD Milliseconds
								)

{

	DWORD   WStatus;
	DWORD   Status;
	if (WaitAll && WaitType==WAITALLSEQUENTIAL) {

        //Sequential Wait for waitall	   
       DWORD iCount;
	   DWORD Index=0;
	   DWORD ta,te;
	   Status=WAIT_OBJECT_0; //optimistic assumption
	   do {
       ta=GetTickCount();
	   if (MAXIMUM_WAIT_OBJECTS <= Count) iCount=MAXIMUM_WAIT_OBJECTS; else iCount=Count; 

       WStatus=WaitForMultipleObjects(iCount,&pHandles[Index],WaitAll,Milliseconds);
       if (WAIT_FAILED == WStatus) {Status=WAIT_FAILED; break;}
	   if (WAIT_ABANDONED_0==WStatus) {Status=WAIT_ABANDONEDEX_0; break;}
	   if (WAIT_TIMEOUT ==WStatus) { Milliseconds=0; Status=WAIT_TIMEOUTEX; }     
	   if (INFINITE != Milliseconds && Milliseconds > 0) {
		   te=GetTickCount(); 
		   if (Milliseconds > (te-ta)) Milliseconds -= (te-ta); else Milliseconds=0;
	   }		
	   Index+=iCount;
	   Count-=iCount;
	   } while (Count >0);	   

	}
	else {
	for (int t=0; t<WThreadCount; t++) {

		if (WaitAll)
			//for WaitAll no local copy of Handles is necessary, just use offset in Handle table 
			pWThreadData[t].pHandles=&pHandles[t*Maximum_Wait_Objects];
		else {
			// WaitAny needs one extra handle for a terminate event, so it copies max. MAXIMUM_WAIT_OBJECTSEX-1 Handles to local table    

			for (DWORD i=0;i< pWThreadData[t].Count; i++) pWThreadData[t].pLocalHandles[i]=pHandles[t*Maximum_Wait_Objects+i];
			pWThreadData[t].pLocalHandles[pWThreadData[t].Count++]=hTerminateEvent; // add event handle
			pWThreadData[t].pHandles=pWThreadData[t].pLocalHandles;
		}

		pWThreadData[t].Milliseconds=Milliseconds;
		pWThreadData[t].WaitAll=WaitAll;

		ResumeThread(pWHandles[t]);

	}
	WStatus=WaitForMultipleObjects(WThreadCount,pWHandles,WaitAll,INFINITE);
	

	if (WaitAll) Status=GetWaitAllStatus(WStatus);
	else { 
		Status=GetWaitAnyStatus(WStatus);
		if (Status!=WAIT_TIMEOUTEX) TerminateWaitByEvent(WStatus - WAIT_OBJECT_0);
	}
	}
	return Status;
}

//Wrapperfunction for C which constructs and destroys Cwait class on each call

DWORD WINAPI WaitForManyObjects(
  __in  DWORD Count,
  __in  const PHANDLE pHandles,
  __in  BOOL WaitAll,
  __in  DWORD Milliseconds
  )
 
{
	  DWORD Status; 
	  if (Count<=MAXIMUM_WAIT_OBJECTSEX) {
		Status=WaitForMultipleObjects(Count,pHandles,WaitAll,Milliseconds); 
		//recalculate Status
        if ((Status >=WAIT_ABANDONED_0) & (Status < WAIT_ABANDONED_0+MAXIMUM_WAIT_OBJECTS))
			Status+=WAIT_ABANDONEDEX_0 - WAIT_ABANDONED_0;
		else if (Status==WAIT_TIMEOUT) Status=WAIT_TIMEOUTEX;	 
	} 
	  else { 
		  WAITTYPE WaitType;
		  if (WaitAll) WaitType=WAITALLDEFAULT; else WaitType=WAITANYTHREADS;
		  CWait MyWait(WaitType,Count);
		  if (!MyWait.GetCreateResult()) Status=WAIT_RAISE_EXCEPTION;
		  else Status=MyWait.WaitForManyObjects(Count,pHandles,WaitAll,Milliseconds); 
		  if (Status==WAIT_RAISE_EXCEPTION) RaiseException (EXCEPTION_NONCONTINUABLE_EXCEPTION,1,0,0);

	  }
 return Status; 
}

