﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Audio;

namespace FireBirdsExtends
{
    public class Player
    {
        //Variable für unsere Grafik
        public Texture2D texPlayer;

        //X,Y, Textur Breite und Höhe
        public Rectangle recPlayerPositionAndDimension;
        public Rectangle recAnimationSource;

        const int SHOOTYOFFSET = 48 - 32;
        const int SHOOT1XOFFSET = 84 - 32;
        const int SHOOT2XOFFSET = 171 - 32;
        const int SHOOTRATIONPERSECONDS = 7;

        double ShootRatioTimer = 0;

        public List<Bullet> bulletList = new List<Bullet>();
      

        ContentManager Content;
        GraphicsDevice graphics;

        SoundEffect flySound;
        SoundEffectInstance flySoundInstance;

        SoundEffect bulletSound;


        public void LoadContent(ContentManager Content,GraphicsDevice graphics)
        {
            //Die Konvertierte XNB Datei wird in texEnemy geladen
            texPlayer = Content.Load<Texture2D>("Graphics\\spitfire");
           
            //Wir weisen unserer Variable eine Position und Grösse zu
            //Unsere Player Grafik besteht aus 6x2 einzelteilen. 
            //Da wir nur immer eine Grafik anzeigen wollen müssen wir die Breite / 6 und die Höhe / 2 rechnen.
            recPlayerPositionAndDimension.X         = graphics.Viewport.Width / 2 - texPlayer.Width / 12;
            recPlayerPositionAndDimension.Y         = graphics.Viewport.Height / 2 - texPlayer.Height / 4;
            recPlayerPositionAndDimension.Width     = texPlayer.Width / 6 ;
            recPlayerPositionAndDimension.Height    = texPlayer.Height / 2;

            recAnimationSource.X = 0;
            recAnimationSource.Y = 0;
            recAnimationSource.Width = texPlayer.Width / 6;
            recAnimationSource.Height = texPlayer.Height / 2;

            this.Content = Content;
            this.graphics = graphics;

            flySound = Content.Load<SoundEffect>("Sound\\flySound");
            flySoundInstance = flySound.CreateInstance();
            flySoundInstance.IsLooped = true;
            flySoundInstance.Play();

            bulletSound = Content.Load<SoundEffect>("Sound\\bulletSound");

        }

        public void Update(GameTime gameTime)
        {
            //Falls die Pfeiltaste nach oben gedrückt wurde, verschieben wir den Player in der Y Achse um eins nach oben
            if(Keyboard.GetState().IsKeyDown(Keys.Up))
            {
                //Wir bewegen den Player nur solange wie die Aktuelle Position auf der Y Achse Grösser als 5 ist. 
                //Ist dies nicht der Fall so setzen wir den Player an die Oberkante des Fensters
                if (recPlayerPositionAndDimension.Y > 5)
                {
                    recPlayerPositionAndDimension.Y -= 5;
                }
                else
                {
                    recPlayerPositionAndDimension.Y = 0;
                }
                
            }else //Falls die Pfeiltaste nach unten gedrückt wurde, verschieben wir den Player in der Y Achse um eins nach unten
            if (Keyboard.GetState().IsKeyDown(Keys.Down))
            {
                if (recPlayerPositionAndDimension.Y + recPlayerPositionAndDimension.Height < graphics.Viewport.Height - 5)
                {
                    recPlayerPositionAndDimension.Y += 5;
                }
                else
                {
                    recPlayerPositionAndDimension.Y = graphics.Viewport.Height - recPlayerPositionAndDimension.Height;
                }
                
            }

            //Falls die Pfeiltaste nach unten gedrückt wurde, verschieben wir den Player in der X Achse um eins nach links
            if (Keyboard.GetState().IsKeyDown(Keys.Left))
            {
                if (recPlayerPositionAndDimension.X > 5)
                {
                    recPlayerPositionAndDimension.X -= 5;
                }
                else
                {
                    recPlayerPositionAndDimension.X = 0;
                }
                
            }else //Falls die Pfeiltaste nach unten gedrückt wurde, verschieben wir den Player in der X Achse um eins nach rechts
            if (Keyboard.GetState().IsKeyDown(Keys.Right))
            {
                if (recPlayerPositionAndDimension.X + recPlayerPositionAndDimension.Width < graphics.Viewport.Width - 5)
                {
                    recPlayerPositionAndDimension.X += 5;
                }
                else
                {
                    recPlayerPositionAndDimension.X = graphics.Viewport.Width - recPlayerPositionAndDimension.Width;
                }
                
            }


            ShootRatioTimer += (float)gameTime.ElapsedGameTime.TotalSeconds;

            if (Keyboard.GetState().IsKeyDown(Keys.Space))
            {
                //Sobald der Timer grösser als 1/ die Anzahl der Schüsse pro Sekunde generieren wir 2 neue Schüsse
                if (ShootRatioTimer >= (1.0f / SHOOTRATIONPERSECONDS))
                {
                    Bullet newBullet = new Bullet(recPlayerPositionAndDimension.X + SHOOT1XOFFSET, recPlayerPositionAndDimension.Y + SHOOTYOFFSET);
                    newBullet.LoadContent(Content, graphics);
                    bulletList.Add(newBullet);

                    Bullet newBullet1 = new Bullet(recPlayerPositionAndDimension.X + SHOOT2XOFFSET, recPlayerPositionAndDimension.Y + SHOOTYOFFSET);
                    newBullet1.LoadContent(Content, graphics);
                    bulletList.Add(newBullet1);

                    ShootRatioTimer = 0;

                    //Der Schussound wird abgespielt.
                    bulletSound.Play();
                }
            }

            //Wir Aktualisieren jeden einzelnen Schuss
            foreach (Bullet bullet in bulletList)
            {
                bullet.Update();
            }

            //Wir zeigen das nächste Bild von unserem Player an
            recAnimationSource.X += 256;

            //Sobald das letzte Bild der Zeile 1 erreicht ist, springen wir auf die zweite Zeile. 
            if (recAnimationSource.X == 1536 && recAnimationSource.Y != 256)
            {
                recAnimationSource.X = 0;
                recAnimationSource.Y = 256;
            }
            //Haben wir das letzte Bild der Zeile 2 erreicht, springen wir auf die Anfangsposition der ersten Zeile zurück
            else if (recAnimationSource.X == 1536 && recAnimationSource.Y == 256)
            {
                recAnimationSource.X = 0;
                recAnimationSource.Y = 0;
            }

        }

        public bool CheckCollision(Rectangle enemyPosition)
        {
            //Hier prüfen wir mit der Intersects Funktion, ob sich der Player mit dem Gegner Berührt
            if (recPlayerPositionAndDimension.Intersects(enemyPosition))
            {
                //Falls dies zutrifft, geben wir dem Hauptprogramm true zurück
                return true;
            }

            //Wenn nicht dann geben wir false zurück
            return false;
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            //Wir weisen die Stapelverarbeitung an, unserer Grafik texEnemy, mit der Position und der Dimension welche sich in der Variable recEnemyPositionAndDimension befindet zu zeichnen
            spriteBatch.Draw(texPlayer, recPlayerPositionAndDimension,recAnimationSource, Color.White);

            foreach (Bullet bullet in bulletList)
            {
                bullet.Draw(spriteBatch);
            }
        }
    }


}
