﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Audio;

namespace FireBirdsExtends
{
    public class Enemy
    {
        //Variable für unsere Grafik
        public Texture2D texEnemy;
        
        //X,Y, Textur Breite und Höhe
        public Rectangle recEnemyPositionAndDimension;
        public Rectangle recAnimationSource;

        public Texture2D texExplosion;
        
        public bool showExplosion = false;
        public bool IsActive = true;


        SoundEffect enemyDeath;

        GraphicsDevice graphics;

        public void LoadContent(ContentManager Content, GraphicsDevice graphics)
        {
            //Die Konvertierte XNB Datei wird in texEnemy geladen
            texEnemy = Content.Load<Texture2D>("Graphics\\enemy");
            texExplosion = Content.Load<Texture2D>("Graphics\\explosion");
            
            enemyDeath      = Content.Load<SoundEffect>("Sound\\enemyDeath");

            //Wir weisen unserer Variable eine Position und Grösse zu.
            //Unsere Enemy Grafik besteht aus 6x2 einzelteilen. 
            //Da wir nur immer eine Grafik anzeigen wollen müssen wir die Breite / 6 und die Höhe / 2 rechnen.
            recEnemyPositionAndDimension.X = 0;
            recEnemyPositionAndDimension.Y = -texEnemy.Height;
            recEnemyPositionAndDimension.Width  = texEnemy.Width / 6;
            recEnemyPositionAndDimension.Height = texEnemy.Height / 2;

            //Dieses Rectangle brauchen wir um den Auschnitt, welchen wir von der Grafik Rendern möchten, zu definieren.
            recAnimationSource.X = 0;
            recAnimationSource.Y = 0;
            recAnimationSource.Width    = texEnemy.Width / 6;
            recAnimationSource.Height   = texEnemy.Height / 2;

            this.graphics = graphics;
        }


        public void Update()
        {
            if (IsActive)
            {
                //Der Gegner wir bei jedem aufruf um 5 Pixel nach unten geschoben
                recEnemyPositionAndDimension.Y +=5;
                
                //Jedes Frame zeigen wir den nächsten Ausschnitt von unserer Grafik an
                recAnimationSource.X += 256;

                //Ist unsere Maske am Ende der ersten Zeile angelangt, setzten wir diese auf das erste Bild der nächsten Reihe
                if (recAnimationSource.X == 1536 && recAnimationSource.Y != 256)
                {
                    recAnimationSource.X = 0;
                    recAnimationSource.Y = 256;

                    if (showExplosion)
                    {
                        IsActive = false;
                    }
                    
                }
                //Sobald das Ende der Zweiten Zeile Erreicht ist, setzten wir den Curser an die Anfangsposition der ersten Zeile
                else if (recAnimationSource.X == 1536 && recAnimationSource.Y == 256)
                {
                    recAnimationSource.X = 0;
                    recAnimationSource.Y = 0;
                }

                //Befindet sich der Gegner ausserhalb des Fensters, so deaktivieren wir diesen 
                if (recEnemyPositionAndDimension.Y > graphics.Viewport.Height)
                    IsActive = false;
            }
        }

        public void ShowExplosion()
        {
            //In dieser Funktion wechseln wir die Aktuelle Enemy Textur mit der Explosionstextur aus und setzen den Cursor zurück auf Anfangsposition zurück
            texEnemy = texExplosion;
            recAnimationSource.X = 0;
            showExplosion = true;
            enemyDeath.Play();
        }

        public bool CheckCollision(Rectangle enemyPosition)
        {
            if (showExplosion)
                return false;

            //Hier prüfen wir mit der Intersects Funktion, ob sich der Player mit dem Gegner Berührt
            //Falls ja, zeigen wir die Explosion an
            if (recEnemyPositionAndDimension.Intersects(enemyPosition))
            {
                ShowExplosion();
                return true;
            }

            //Wenn nicht dann geben wir false zurück
            return false;
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            //Wir weisen die Stapelverarbeitung an unserer Grafik texEnemy, mit der Position und Dimension des recEnemyPositionAndDimension zu zeichnen
            if (IsActive)
            {
                spriteBatch.Draw(texEnemy, recEnemyPositionAndDimension, recAnimationSource, Color.White);
            }
            
        }
    }
}
