﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;

namespace FireBirdsExtends
{
    public class Bullet
    {
        //Variable für unsere Grafik
        public Texture2D texBullet;

        //X,Y, Textur Breite und Höhe
        public Rectangle recBulletPositionAndDimension;

        //Da wir die Animationen wie ein Daumenkino realisieren, brauchen wir ein zusätzliches Rectangle,
        //welches uns den Aktuellen Ausschnitt der Textur wiedergibt. 
        public Rectangle recAnimationSource;

        //Schaltervariable. Wenn diese auf false ist, wird der Aktuelle Schuss gelöscht
        public bool IsActive = true;

        public Bullet(int iPositionX, int iPositionY)
        {
            recBulletPositionAndDimension.X = iPositionX;
            recBulletPositionAndDimension.Y = iPositionY;
        }

        public void LoadContent(ContentManager Content, GraphicsDevice graphics)
        {
            //Die Konvertierte XNB Datei wird in texEnemy geladen
            texBullet = Content.Load<Texture2D>("Graphics\\bullet");

            //Wir weisen unserer Variable eine Position und Grösse zu.
            //Da unsere Bullet Grafik nun aus 12 aneinandergereiten einzelteilen besteht. Müssen wir die Breite / 12 rechnen.
            recBulletPositionAndDimension.Width     = texBullet.Width / 12;
            recBulletPositionAndDimension.Height    = texBullet.Height;

            //Dieses Rectangle brauchen wir um den Auschnitt, welchen wir von der Grafik Rendern möchte zu definieren.
            //Aus diesem Grund auch hier die Breite / 12
            recAnimationSource.X = 0;
            recAnimationSource.Y = 0;
            recAnimationSource.Width    = texBullet.Width / 12;
            recAnimationSource.Height   = texBullet.Height;
        }

        public void Update()
        {
            //Sobald der Schuss nicht mehr Aktiv ist brechen wir die Update Funktion ab
            if (!IsActive)
                return;
             
            //Der Schuss wir um -6 in der Y Achse bewegt
            recBulletPositionAndDimension.Y -= 6;

            //Die Maske wird um 64 Pixel nach rechts verschoben. Es wird nun Bild 2 angezeigt
            recAnimationSource.X += 64;

            if (recAnimationSource.X == 768)
            {
                //Sobald das Ende der Grafik erreicht ist, springen wir wieder auf 0 um die erste Grafik anzuzeigen
                recAnimationSource.X = 0;
            }

            //Sobald der Schuss auserhalb des Bildschirms ist wollen wir diesen löschen
            if (recBulletPositionAndDimension.Y + texBullet.Height < 0)
                IsActive = false;
            
        }

     

        public void Draw(SpriteBatch spriteBatch)
        {
            if (IsActive)
            {
                spriteBatch.Draw(texBullet, recBulletPositionAndDimension, recAnimationSource, Color.White);
            }
        }
    }
}
