#!/bin/sh
# simple-ipv6-firewall
# Reiko Kaps 2011 <rek@ct.de>
#
# kann ber /etc/network/interfaces oder /etc/rc.local
# automatisch gestartet werden

LO=lo
WAN=aiccu 	# fr gogo6 in 'tun' ndern
LAN=eth0.2 	# unter Debian meist nur eth0
PREFIX=""

[ -z $PREFIX ] && {
	logger -s -t IPv6firewall "Kein Prefix gesetzt, Firewall nicht aktiv."
	logger -s -t IPv6firewall "Bitte bearbeiten Sie die Datei $0."
	exit 1
}

# zuerst alles lschen
ip6tables -F
ip6tables -X

# Allow anything on the local link
ip6tables -A INPUT  -i $LO -j ACCEPT
ip6tables -A OUTPUT -o $LO -j ACCEPT

# Allow anything out on the internet
ip6tables -A OUTPUT -o $WAN -j ACCEPT

# Allow the localnet access us:
ip6tables -A INPUT    -i $LAN   -j ACCEPT
ip6tables -A OUTPUT   -o $LAN   -j ACCEPT

# Filter all packets that have RH0 headers:
ip6tables -A INPUT -m rt --rt-type 0 -j DROP
ip6tables -A FORWARD -m rt --rt-type 0 -j DROP
ip6tables -A OUTPUT -m rt --rt-type 0 -j DROP

# Allow Link-Local addresses
ip6tables -A INPUT -s fe80::/10 -j ACCEPT
ip6tables -A OUTPUT -s fe80::/10 -j ACCEPT

# Allow multicast
ip6tables -A INPUT -s ff00::/8 -j ACCEPT
ip6tables -A OUTPUT -s ff00::/8 -j ACCEPT

# Allow ICMPv6 everywhere
ip6tables -I INPUT  -p icmpv6 -j ACCEPT
ip6tables -I OUTPUT -p icmpv6 -j ACCEPT
ip6tables -I FORWARD -p icmpv6 -j ACCEPT

# Allow forwarding
ip6tables -A FORWARD -m state --state NEW -i $LAN -o $WAN -s $PREFIX -j ACCEPT
ip6tables -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT

## SSH auf LAN-Rechner erlauben
# ip6tables -A FORWARD -i $WAN -p tcp -d 2001:db8::21c:c0ff:fec2:790f --dport 22 -j ACCEPT

# alles mitschreiben
#ip6tables -A INPUT -j LOG --log-prefix "IPv6-INPUT:"
#ip6tables -A FORWARD -j LOG --log-prefix "IPv6-FORWARD:"
#ip6tables -A OUTPUT -j LOG --log-prefix "IPv6-OUTPUT:"

# Per Vorgabe alles verwerfen
ip6tables -P INPUT   DROP
ip6tables -P FORWARD DROP
ip6tables -P OUTPUT  DROP
