#!/bin/sh

# cleanup-script soll nur weiterlaufen, wenn
# keinpasswort durch aufs geschützt wird.
immutable=`mount -l -t aufs |grep 'none on /home/keinpasswort type aufs (rw,br:/home/.keinpasswort_rw:/home/keinpasswort)'`
test -n "$immutable" || exit 0;

# Lösch-Funktion, welcher zusätzliche find-Argumente übergeben werden können
loeschen (){
  # Verwaltungs-Objekte von aufs
  no_aufs="! -name .wh..wh.aufs ! -name .wh..wh.orph ! -name .wh..wh.plnk"
  # Zusätliches find-Argument speichern
  zusatz="$1"
  # Wird dieses Script als root ausgeführt, kann das folgende "rm -rf" sehr gefährlich werden --
  # insbesondere zu Testzwecken auf einem normalen Arbeitsrechner. Mit der folgenden Kombination
  # ist sichergestellt, dass wirklich nur der Inhalt von .keinpasswort_rw gelöscht wird.
  cd /home/.keinpasswort_rw && find . -maxdepth 1 -mindepth 1 $no_aufs $zusatz -print0|xargs -0 rm -rf
}

case "$1" in
  /etc/gdm/PostLogin/Default)
    # Inhalt von .keinpasswort_rw beim Login löschen. Das .pulse-Verzeichnis muss stehen
    # bleiben, da es sonst bei direkter Neuanmeldung zu Sound-Problemen kommen kann.
    loeschen "! -name .pulse"
    # Unter winxp das device winxp-hda.vdi auf immutable setzen. Die Einträge 
    # müssen an die lokale Situation angepasst sein.
    sudo -u keinpasswort VBoxManage storageattach winxp --storagectl "IDE Controller" --port 0 --device 0 --type hdd --medium none
    sudo -u keinpasswort VBoxManage modifyhd winxp-hda.vdi --type immutable
    sudo -u keinpasswort VBoxManage storageattach winxp --storagectl "IDE Controller" --port 0 --device 0 --type hdd --medium winxp-hda.vdi
    ;;
  /etc/gdm/PostSession/Default)
    # Inhalt von .keinpasswort_rw beim Logout verzögert löschen.
    (sleep 3; loeschen "! -name .pulse") &
    ;;
  /etc/rc.local)
    # Inhalt von .keinpasswort_rw beim Booten löschen, damit keine untergeschobenen
    # Dateien einen Neustart überdauern. Sowohl das .pulse-Verzeichnis als auch
    # Shell-Logins könnten sonst als Schwachstelle ausgenutzt werden.
    loeschen
    ;;
  *)
    # Nichts tun
    ;;
esac
exit 0
