@echo off %debug%
rem
rem (c)2010 c't, Johannes Endres
rem
rem Batch-Skript zum Artikel "Hochgeschoben" in c't 2/11, Seite 178
rem 
setlocal enabledelayedexpansion

rem Die Verzeichnisse, die gesichert werden sollen, als Komma-getrennte Liste.
rem Falls der Pfad Leerzeichen enthlt, muss er in Anfhrungszeichen stehen.
rem Die Pfade mssen komplett mit Laufwerksbuchstaben angegeben werden.
rem Beispiel: set dirs=c:\windows, "d:\Meine Fotos", "%userprofile%"
set dirs=HIER TRAGEN SIE DIE VERZEICHNISSE EIN

rem Ihr Hidrive-Username
set hiuser=HIERHER KOMMT DER HIDIRVE-USERNAME

rem Der Name des Backup-Verzeichnisses auf dem Server
set backupdir=Backup

rem Anfangs sollte man im Protokoll kontrollieren, ob alles klappt
set logfile=%appdata%\rsynclog.txt

rem --- Ende der Konfiguration ---

set HOME=%appdata%

rem Das Verzeichnis mit rsync finden
rem Zuerst im Pfad nachsehen
call :expandpath rsync.exe
if exist %cwrpath%rsync.exe goto setrsh

rem Der Standardinstallationspfad auf 32-Bit-Windows
set cwrpath="%ProgramFiles%\cwRsync\bin\"
if exist %cwrpath%rsync.exe goto setrsh

rem cwRSync ist ein 32-Bit-Programm, deshalb lautet der Pfad auf 64-Bit-Windows anders
if exist "%ProgramFiles(x86)%" set cwrpath="%ProgramFiles(x86)%\cwRsync\bin\"
if exist %cwrpath%rsync.exe goto setrsh

echo Konnte den Pfad zu rsync.exe nicht bestimmen.
exit/b

:setrsh
rem Der Aufruf aus dem PATH klappt manchmal nicht, also kompletten Pfadnamen benutzen.
rem Falls der private Schlssel nicht %home%\.ssh\id_rsa ist, geben Sie ihn hier mit -i an.
rem Groschreibung des Varaiablennamens ist wichtig
set RSYNC_RSH=%cwrpath%ssh.exe

if not ""=="%logfile%" (
	call :cygpath "%logfile%" logfile
	set logopt=--verbose --log-file=!logfile!
)

rem Die folgende Schleife arbeitet sich durch die oben angegebenen Verzeichnisse
for %%p in (%dirs%) do (
	rem Den Pfad in cygwin-Notation umwandeln
	call :cygpath %%p lokal
	%cwrpath%rsync %logopt% -az "!lokal!" %hiuser%@rsync.hidrive.strato.com:/users/%hiuser%/%backupdir%/
)
exit/b

rem Diese Funktion sucht den bergebenen Programmnamen im Pfad und gibt den Pfad der Fundstelle zurck
:expandpath
set cwrpath="%~dp$PATH:1"
exit/b

rem Diese Funktion wandelt einen Pfad in cygwin-Notation um
rem Erster Parameter: Der Pfad in DOS- oder cygwin-Notation
rem Zweiter Parameter: Der Name der Variable, die hinterher den Pfad enthalten soll
:cygpath
rem Falls der Pfad schon im Cygwin-Format ist, keine Umwandlung
echo %~1 | findstr /I /B \/cygdrive/ > nul && (
	set %2=%~1
	exit/b
)

rem Etwas Batch-Magie, um einen Pfad in Cygwin-Notation umzuwandeln
rem Einmal zuweisen, weil die Ersetzungen nicht mit %1 funktionieren
rem Auerdem korrigiert diese Zuweisung die Kleinschreibung der Pfade
set x=%~dpnx1
rem \ durch / ersetzen
set p=%x:\=/%
rem Doppelpunkte entfernen, die ohnehin nur beim Laufwerksbuchstaben vorkommen
set d=%p::=%
rem /cygdrive/ davor und an die genannte Variable zuweisen
set %2=/cygdrive/%d%

exit /b
