#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <random>
#include <functional> // bind
using namespace std;

default_random_engine engine;

template<typename DISTRIBUTION>
void one(DISTRIBUTION &range, size_t n, const char *name) {
  cout << name << " # ";
  vector<size_t> count(n,0);
  for(int i=0; i<1000; ++i) {
    const size_t r = static_cast<size_t>( range(engine) );
    cerr << r << " ";
    count[r] += 1;
  }
  for(size_t i=0; i<n; ++i)
    cout << count[i] << " ";
  cout << endl;
}


int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  uniform_int_distribution<size_t> uniform{0,19}  ;
  one(uniform, 20, "uniform");

  normal_distribution<double> normal{0.0,19.0};
  one(normal, 20, "normal");

  return EXIT_SUCCESS;
}
