#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <chrono>
#define _GLIBCXX_USE_NANOSLEEP // sleep_for()
#include <thread>
using namespace std;
using namespace chrono;

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  const monotonic_clock::time_point start = monotonic_clock::now();
    
  cerr << "zigzag(...) -- Collatz Problem";
  for(int n=0; n<200;++n) {
    if(n%10 == 0) cerr << endl;
    int z = n;
    int i = 0;
    for(i=0; z>1; ++i)
      z = z%2 == 0 ? z/2 : z*3+1;
    cerr << setw(5) << i;
  }

  const auto now = monotonic_clock::now();
  const nanoseconds  dur1 = now - start;
  const microseconds dur2 = duration_cast<microseconds>(now - start);
  const milliseconds dur3 = duration_cast<milliseconds>(now - start);
  cerr << endl
       << "  duration: " << dur1.count() << " nanos" << endl
       << "        or: " << dur2.count() << " micros" << endl
       << "        or: " << dur3.count() << " millis" << endl;
  
  this_thread::sleep_for(seconds(1));

  seconds sec1 = hours(2) + minutes(35) + seconds(9);
  cerr << " 2h,35m,9s: " << sec1.count() << endl;

  return EXIT_SUCCESS;
}
