#include <iostream>
#include <cstdlib>

static const int SZ = 1000;

void dummy_load(const char *, char *) { }
  

// compiler adds copy and assign, but not Image1()
class Image1 {
  char data[SZ];
public:
  Image1(const char *filename) { dummy_load(filename,data); };
};

// prevent copy, assign the old style
class Image2 {
  char data[SZ];
public:
  Image2(const char *filename) { dummy_load(filename,data); };
private:
  Image2(const Image2&); // no impl, no copy
  Image2& operator=(const Image2&); // no impl, no copy
};

// new way of preventing copy and assign
class Image3 {
  char data[SZ];
public:
  Image3(const char *filename) { dummy_load(filename,data); };
  Image3(const Image3&) = delete;
  Image3& operator=(const Image3&) = delete;
};

// new way of telling user that copy and assign will be there
class Image4 {
  char data[SZ];
public:
  Image4(const char *filename) { dummy_load(filename,data); };
  Image4(const Image4&) = default;
  Image4& operator=(const Image4&) = default;
  Image4() = default; // new! let compiler add this
};


int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  std::cerr << "  Image1" << std::endl;
  //no! compiler did not generate default c'tor
  // Image1 i1;
  Image1 j1("dummy");
  Image1 k1( j1 ); // compiler generated copy

  std::cerr << "  Image2" << std::endl;
  Image2 i2("dummy");
  //no! you made copy private
  // Image2 j2( i2 ); 

  std::cerr << "  Image3" << std::endl;
  Image3 i3("dummy");
  //no! you deleted copy
  // Image3 j3( i3 ); 

  std::cerr << "  Image4" << std::endl;
  Image4 i4("dummy");
  Image4 j4( i4 ); // explicit default copy
  Image4 k4; // explicitly added default c'tor

  return EXIT_SUCCESS;
}
