// variadic template test, no iostreams to keep binary small
#include <cstdio>

//////////////////////////////////////////////////////////////////////

// print 1 element of any type
template<typename T> static void yprint1(T const&);
template<> void yprint1<const char*>(const char* const &s) { printf("%s", s); }
template<> void yprint1<int>        (int const& i)         { printf("%d", i); }

static void yprint() {                         //! ending recursion
  printf("\n");
}

template<typename T, typename ...U>
static void yprint(const T&t, const U... u) {  //! n+1 arguments
  yprint1(t);
  yprint(u...);                                //! recursive call, n arguments
}


//////////////////////////////////////////////////////////////////////

int main() {
  printf("=== %s ===\n", __FILE__);

  yprint(7, "*", 3, " ist ", 7*3);             //! calling vartempl func
   
  return 0;
}

//- eof
