/** tests anonymous types a template arg */
#include <vector>
#include <iostream>
#include <algorithm>
using namespace std;

//:begin
static void printall_localType(vector<int> &v) {
 struct PrintOp {
   void operator()(int i) { cout<<i<<" "; }
 };
 for_each(v.begin(), v.end(), PrintOp());  //! local functor as templ arg
 cout << endl;
}

static void printall_anonType(vector<int> &v) {
 struct {
   void operator()(int i) { cout<<i<<" "; }
 } printop;
 for_each(v.begin(), v.end(), printop);  //! use anon type
 cout << endl;
}

static void printall_lambda(vector<int> &v) {
  for_each(v.begin(), v.end(), [](int i){ cout<<i<<" "; }); //! use lambda
 cout << endl;
}
//:end

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  vector<int> vec;
  for(int i=0; i<10; ++i)
    vec.push_back(i*i);

  cerr << "    local type: ";
  printall_localType(vec);

  cerr << "anonymous type: ";
  printall_anonType(vec);

  cerr << "        lambda: ";
  printall_lambda(vec);

  return EXIT_SUCCESS;
}
