// rvalue references demo, not so good a way to do it
#include <vector>
#include <algorithm>  // generate_n, copy
#include <iostream>   // cerr
#include "_numbers.hpp" // Number, Quadrate

class Teuer {
  int sz;
public:
  Number* data;  // pointer member
  explicit Teuer(int size) : sz(size), data()
  {
    data = new Number[sz];
    std::generate_n(data, sz, Quadrate());
  }
  ~Teuer() 
  { delete[] data; data=NULL;} // hopefully data is not shared
  Teuer(const Teuer& oth); // deep copy needed //=b
  Teuer& operator=(const Teuer& oth); // deep assign needed //=b
};

Teuer::Teuer(const Teuer& oth) 
  : sz(oth.sz), data()
{
  data = new Number[sz]; // create new space //=b
  std::copy(oth.data, oth.data+sz, data); // deep copy //=b
}

Teuer dingFactory(int decide) {  // (2) copy needed
  Teuer result(100); // (1) create
  if(decide == 0)
    return result;
  else { // never reached, but prevent return-value-optimization
    Teuer result2(999999999); 
    result2.data[5] = result.data[6];
    return result2;
  }
}

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  int dec = -1;

  Number::stats(std::cerr);
  {
    std::cerr << "  create object1..." << std::endl;
    Teuer ding1(100);
    Number::stats(std::cerr);

    std::cerr << "  make a copy of object1..." << std::endl;
    Teuer ding2(ding1);   // this version makes a deep copy //=b
    Number::stats(std::cerr);

    dec = ding2.data[0]-1; // 0

    // ding2 will be destroyed here
    // ding1 will be destroyed here
  } 
  Number::stats(std::cerr); // no leak in this version //=b
 
  {
    std::cerr << "  use makeDing() factory..." << std::endl;
    Teuer ding3 = dingFactory(dec); // dec is 0
  }
  Number::stats(std::cerr);

  return EXIT_SUCCESS;
}
//- eof
