// rvalue references demo, how _not_ to do it
#include <vector>
#include <algorithm>  // generate_n
#include <iostream>   // cerr
#include "_numbers.hpp" // Number, Quadrate

class Leaking {
  int sz;
  Number* data;  // pointer member, containing 'expensive' data //=b
public:
  explicit Leaking(int size) : sz(size), data()
  {
    data = new Number[sz]; // create data //=b
    std::generate_n(data, sz, Quadrate());
  }
};

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  Number::stats(std::cerr);
  {
    std::cerr << "  create object1..." << std::endl;
    Leaking ding1(100);
    Number::stats(std::cerr);

    std::cerr << "  make a copy of object1..." << std::endl;
    Leaking ding2(ding2);
    Number::stats(std::cerr);

    // ding2 will be destroyed here
    // ding1 will be destroyed here
  }
  Number::stats(std::cerr); // leak will show here //=b
  
  return EXIT_SUCCESS;
}
//- eof
