// initializer list for C structs

#include <vector>
#include <iostream>
#include <initializer_list> //! include needed

//////////////////////////////////////////////////////////////////////

struct SomeInts {
  std::vector<int> cont_;
  SomeInts(std::initializer_list<int> list) : cont_() {
    cont_.assign(list.begin(), list.end());
  }
  int operator[](size_t i) const { return cont_[i]; }
};

struct PureC {
  int a, b, c;
};
  
//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;
  
  std::cerr << "The int-vector from int-list:";
  SomeInts v { 1001, 2022, 3333 }; //!=b call init list ctor
  std::cerr << v[0] << " " << v[1] << " " << v[2] << std::endl;

  std::cerr << "The Pure-C init from int-list:";
  PureC c = { 101, 102, 103 };
  std::cerr << c.a << " " << c.b << " " << c.c << std::endl;
    
  return EXIT_SUCCESS;
}

//- eof
