// initializer list function demo

#include <iostream>
#include <initializer_list> //! include for init'er list
#include <algorithm>        // copy
#include <iterator>         // ostream_iterator

//////////////////////////////////////////////////////////////////////

static
void dump_ints(std::initializer_list<int> list) //!=b free function with init'er list
{
  std::ostream_iterator<int> oit(std::cout, " "); // copies elements to cout //=b
  std::copy(list.begin(), list.end(), oit);       // init'er list behaves like std container
  std::cout << std::endl;
}

//////////////////////////////////////////////////////////////////////

int main() {
  std::cerr << "=== " << __FILE__ << " ===" << std::endl;

  dump_ints( { 2,3,5,7,13,17 } ); //!=b call free function with init'er list

  return EXIT_SUCCESS;
}

//- eof
