#include <tuple>
#include <iostream>
#include <cstdlib>

template<typename T,typename U, typename V>
std::ostream& operator<<(std::ostream&os, const std::tuple<T,U,V> &t) {
	return os << "<" << std::get<0>(t) << "," << std::get<1>(t) << "," << std::get<2>(t) << ">";
}

int main() {
	std::cerr << "=== " << __FILE__ << " ===" << std::endl;

	std::tuple<int,double,char> tuple(41, 3.14, 'x');
	if(std::get<0>(tuple) != 41)
		return EXIT_FAILURE;
	if(std::get<1>(tuple) != 3.14)
		return EXIT_FAILURE;
	if(std::get<2>(tuple) != 'x')
		return EXIT_FAILURE;
	std::cerr << "  init ok:" << tuple << std::endl;

	// elment-wise converted
	std::tuple<long,long,long> target(tuple);
	std::cerr << "  conversion ok:" << target << std::endl;

	if(target != tuple) {
		std::cerr << "  compare failed, ok." << std::endl;
		return EXIT_SUCCESS;
	}

	std::cerr << "  compare passed, but should have failed." << std::endl;
	return EXIT_FAILURE;
}
