#include <iostream>
#include <cstring>

using namespace std;

template <typename T>
void swap(T& a, T& b) {
	static_assert(sizeof(T) >= 4, "Gnarz!");
    T tmp(a);
    a = b;
    b = tmp;
}


class Foo {
    static const int SZ = 1000;
public:
    Foo()
    {
        cout << "Foo()" << endl;
        a = new int[SZ];
        memset(a, SZ*sizeof(int), 0);
    }
    ~Foo()
    {
        delete [] a;
    }
    Foo(const Foo& foo)
    {
        cout << "Foo() COPY" << endl;
        a = new int[SZ];
        memcpy(a, foo.a, SZ*sizeof(int));
    }
    Foo(Foo&& foo)
    {
        cout << "Foo() MOVE" << endl;
        a = foo.a;
    }
    Foo& operator=(const Foo& foo)
    {
        cout << "COPY =" << endl;
        memcpy(a, foo.a, SZ*sizeof(int));
        return *this;
    }
    Foo& operator=(Foo&& foo)
    {
        cout << "MOVE =" << endl;
        a = foo.a;
        foo.a = nullptr;
        return *this;
    }
    void dump(const char* s) {
        cout << s << " -> " << a << endl;
    }
    int* a;
};


int main(void) {
    Foo foo;
    Foo bar;
    foo.dump("foo");
    bar.dump("bar");
    ::swap<Foo>(foo, bar);
    cout << "foo & bar SWAPPED VIA COPY." << endl;
    foo.dump("foo");
    bar.dump("bar");
    std::swap<Foo>(foo, bar);
    cout << "foo & bar SWAPPED VIA MOVE." << endl;
    foo.dump("foo");
    bar.dump("bar");
    return 0;
}
