// ctpci.h  Schnittstelle zwischen Treiber und Applikation




#define DIRECTNT_TYPE               0x40000
#define IOCTL_DIRECTNT_CONTROL      CTL_CODE(DIRECTNT_TYPE,0x0800,\
				    METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DIRECTNT_CONTROL64    CTL_CODE(DIRECTNT_TYPE,0x0801,\
				    METHOD_BUFFERED,FILE_ANY_ACCESS)


//Opcode: Bit 0..15, ProcNumber (Bit16..31) mit 0=egal, 1=Proc0, ... 
#define OP_Check          1 // gibt immer $12345678 zurueck



#define OP_GetMR         20L // Liest MSR nr #Par1# aus, =>64bittig
#define OP_SetMR         21L // schreibt MSR #Par1#,
                            // #PAR2#= untere 32Bit #Par3#=obere 32 Bit

#define	OP_ReadPhysMemDword 40L // Ein physikalisches Dword vom Speicher #par1# (Hiaddr=#par2#) lesen 
#define	OP_WritePhysMemDword 41L // Ein physikalisches Dword #par2 zum Speicher #par1#  schreiben 


#define OP_ReadPCIDword  60 // falls Bit 31 von #Par1# = 1:
							// liest PCI-Register mit #Par1#=
 							// 31    | 30 ..24 |  23 ..16 | 15..11 | 10.. 8 | 7..2 | 1 0 
							// Enable| Res     |  Bus     | Device | Funct  |index | 00
                            // extended ab V1.18        // Enable| 27..24 = hi_Index   
 
                            // falls Bit 31 von #Par1#= 0:
							// #Par1#= index, #Par2#= bus/dev/func mit
						    // 31..16|15..8|7..3|2..0    
							//  00   | bus |dev |func  

                          
#define OP_WritePCIDword 61 // schreibt PCI-Register #Par1# auf
						    // BUS/DEV/FKN #Par2# den Wert #Par3#  oder 
						    // falls Bit31 (#Par1#) =1 schreibt #Par3# auf #Par1#  


#define OP_FindPCI      66 


typedef struct              //  Struktur der Input-Parameter 32 Bit
{
  ULONG OpCode;
  ULONG Par1;
  ULONG Par2;
  ULONG Par3;
} TctpciInfo,* PctpciInfo;

typedef struct              //  Struktur der Input-Parameter 64 Bit
{
  ULONGLONG OpCode;
  ULONGLONG Par1;
  ULONGLONG Par2;
  ULONGLONG Par3;
} TctpciInfo64,* PctpciInfo64;

typedef struct 
{ 
	ULONG alo;
	ULONG ahi;
	ULONG dlo;
	ULONG dhi;
} int128, *Pint128;

#define STATUS_NO_BUS 0x2L
#define STATUS_NO_DEVICE 0x26L
