


// Directnt.h
// Driver functions
// ctpci.h uses ony OP_ReadPCIDword, OP_WritePCIDword and OP_ReadPhysMemDword  
// and optional OP_GETMR and OP_SETMR
 
#define DIRECTNT_TYPE               0x40000
#define IOCTL_DIRECTNT_CONTROL      CTL_CODE(DIRECTNT_TYPE,0x0800,\
				    METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_DIRECTNT_CONTROL64    CTL_CODE(DIRECTNT_TYPE,0x0801,\
				    METHOD_BUFFERED,FILE_ANY_ACCESS)


//Opcode: Bit 0..15, ProcNumber (Bit16..31) mit 0=egal, 1=Proc0, ... 
#define OP_Check          1L // gibt immer $12345678 zurueck
#define OP_GetCR0         2L // gibt Inhalt von Register CR0 zurueck
#define OP_SetCR0         3L // schreibt Inhalt #Par1# in Register CR0
#define OP_GetCRx         4L // gibt Inthalt Register CRx x=#Par1# zurueck 
#define OP_SetCRx         5L // setzt Inhalt #Par2# in Register CRx, mit x=#Par1#  
#define OP_GetDRx         6L // gibt Inhalt Register DRx x=#Par1# zurueck 
#define OP_SetDRx         7L // setzt Inhalt #Par2# in Register DRx, mit x=#Par1#  
#define OP_GetTRx         8L // gibt Inhalt Register TRx x=#Par1# zurueck 
#define OP_SetTRx         9L // setzt Inhalt #Par2# in Register TRx, mit x=#Par1#    
#define OP_ReadPortByte  10L // gibt Byte-Inhalt von Port #Par1# zurueck
#define OP_WritePortByte 11L // schreibt Byte #Par2# nach Port #Par1#
#define OP_ReadPortWord  12L // gibt Byte-Inhalt von Port #Par1# zurueck
#define OP_WritePortWord 13L // schreibt Byte #Par2# nach Port #Par1#
#define OP_ReadPortDword  14L // gibt Byte-Inhalt von Port #Par1# zurueck
#define OP_WritePortDword 15L // schreibt Byte #Par2# nach Port #Par1#

#define OP_GetMR         20L // Liest MSR nr #Par1# aus, =>64bittig
#define OP_SetMR         21L // schreibt MSR #Par1#,
                            // #PAR2#= untere 32Bit #Par3#=obere 32 Bit
#define OP_CPUID         22L // #PAR1#  => int128  
#define OP_GetMTRR       23L //
#define OP_SetMTRR       24L 
#define OP_RDPMC         25L // #PAR1#=ECX  => int128  
#define OP_GetAMDMR      26L // Liest MSR nr #Par1# aus, =>64bittig
#define OP_SetAMDMR      27L // schreibt MSR #Par1#,

#define OP_ReadMemDword  30L // Ein lineares Dword vom Speicher #par1# lesen
#define OP_WriteMemDword 31L // Ein lineares Dword #par2# zum Speicher #par1# schreiben ab V1.17
#define OP_ReadMemLongLong 32L 
#define OP_WriteMemLongLong 33L
#define	OP_ReadPhysMemDword 40L // Ein physikalisches Dword vom Speicher #par1# (Hiaddr=#par2#) lesen 
#define	OP_WritePhysMemDword 41L // Ein physikalisches Dword #par2 zum Speicher #par1#  schreiben 
#define OP_MmMapIoSpace  42L 
#define OP_MmUnmapIoSpace 43L 
#define OP_ReadPhysMemBlock 44L // einen physikalischen Block ab #Par1# der Lnge #Par2# lesen


#define OP_GiveIO        50L // schaltet Ports #Par1# bis #Par2# frei
#define OP_LoadIOPM      51L // laedt IOPM => pointer auf 8 KByte Daten
#define OP_LockIO        52L // blockiert Ports #Par1# bis #Par2#
#define OP_LoadOwnIOPM   53L 
#define OP_TrapIO        54L // 
#define OP_UnTrapIO      55L
#define OP_ReadPCIDword  60L // falls Bit 31 von #Par1# = 1:
							// liest PCI-Register mit #Par1#=
 							// 31    | 30 ..24 |  23 ..16 | 15..11 | 10.. 8 | 7..2 | 1 0 
							// Enable| Res     |  Bus     | Device | Funct  |index | 00
                            // extended ab V1.18        // Enable| 27..24 = hi_Index   
 
                            // falls Bit 31 von #Par1#= 0:
							// #Par1#= index, #Par2#= bus/dev/func mit
						    // 31..16|15..8|7..3|2..0    
							//  00   | bus |dev |func  

                          
#define OP_WritePCIDword 61L // schreibt PCI-Register #Par1# auf
						    // BUS/DEV/FKN #Par2# den Wert #Par3#  oder 
						    // falls Bit31 (#Par1#) =1 schreibt #Par3# auf #Par1#  

#define OP_ReadPCIWord  62L  // liest PCI-Register #Par1# auf
                            // BUS/DEV/FKN  #Par2#
#define OP_WritePCIWord 63L	// schreibt PCI-Register #Par1# auf
							//  BUS/DEV/FKN #Par2# den Wert #Par3#

#define OP_ReadPCIByte  64L  // liest PCI-Register #Par1# auf
                            // BUS/DEV/FKN  #Par2#
#define OP_WritePCIByte 65L  // schreibt PCI-Register #Par1# auf
							//  BUS/DEV/FKN #Par2# den Wert #Par3#
#define OP_FindPCI      66L 

#define OP_Halt			 70L // setzt den HALT-Befehl ab
#define OP_Delay         71L // wartet #par1* 853ns , liest Differenz aus TSC  
                            // 64bittig nach Result 
#define OP_RaiseIrql     72L // #par1= IRQL neu => IRQL alt 
#define OP_LowerIrql     73L // #par1= IRQL alt 
#define OP_SetProcNumber 74L // #par1 = gewnschter Prozessor, 0: egal, 1..n 
#define OP_Coldfill      75L // REP STOSD => #par1, Lnge #par2, Wert #par3 => (int128) Result: Takte
#define OP_ReadPCIDwordD  80L // Direktes Lesen von PCI per I/O  
                            // falls Bit 31 von #Par1# = 1:
							// liest PCI-Register mit #Par1#=
 							// 31    | 30 ..24 |  23 ..16 | 15..11 | 10.. 8 | 7..2 | 1 0 
							// Enable| Res     |  Bus     | Device | Funct  |index | 00
                            // extended ab V1.18        // Enable| 27..24 = hi_Index   
 
                            // falls Bit 31 von #Par1#= 0:
							// #Par1#= index, #Par2#= bus/dev/func mit
						    // 31..16|15..8|7..3|2..0    
							//  00   | bus |dev |func  

#define OP_WritePCIDwordD  81L 
#define OP_ProcessorInfo 90L // ULONG
#define OP_L2Command     91L 
#define OP_ReadFlags	 99L	// Testfunktion, Flags im Treiber abfragen 

#define OP_GetVersion	 101L // Versionsnummer des Treibers holen (1 Dword)
#define OP_Getaccess     102L  
#define OP_GetCR4        103L 
#define OP_SetCR4        104L
#define OP_MmGetPhysicalAddress 110L 
#define OP_MmAllocateContiguousMemory 111L 
#define OP_MmFreeContiguousMemory 112L 
#define OP_MAP_USER_PHYSICAL_MEMORY 113L 
#define OP_UNMAP_USER_PHYSICAL_MEMORY 114L
#define OP_CLIHLT        150L
#define OP_CLI           151L
#define OP_STI           152L   
#define OP_CallBack      160L // CallBack index, mit index => Procedure ohne Parameter  

#define OP_GetCR0_64     0x202L // gibt Inhalt von Register CR0 zurueck
#define OP_SetCR0_64     0x203L // schreibt Inhalt #Par1# in Register CR0
#define OP_GetCRx_64     0x204L // gibt Inthalt Register CRx x=#Par1# zurueck 
#define OP_SetCRx_64     0x205L // setzt Inhalt #Par2# in Register CRx, mit x=#Par1#  
#define OP_GetDRx_64     0x206L // gibt Inhalt Register DRx x=#Par1# zurueck 
#define OP_SetDRx_64     0x207L // setzt Inhalt #Par2# in Register DRx, mit x=#Par1#  
#define OP_GetCR4_64     0x208L  
#define OP_SetCR4_64     0x209L

#define OP_ReadMemDword_64    0x200L+OP_ReadMemDword        
#define OP_ReadMemLongLong_64 0x200L+OP_ReadMemLongLong
#define OP_GetDirectNTaddr_64 0x270L


typedef struct              //  Struktur der Input-Parameter 32 Bit
{
  ULONG OpCode;
  ULONG Par1;
  ULONG Par2;
  ULONG Par3;
} TDirectNTInfo,* PDirectNTInfo;

typedef struct              //  Struktur der Input-Parameter 64 Bit
{
  ULONGLONG OpCode;
  ULONGLONG Par1;
  ULONGLONG Par2;
  ULONGLONG Par3;
} TDirectNTInfo64,* PDirectNTInfo64;

typedef struct 
{ 
	ULONG alo;
	ULONG ahi;
	ULONG dlo;
	ULONG dhi;
} int128, *Pint128;


#define STATUS_NO_BUS 0x2L
#define STATUS_NO_DEVICE 0x26L
