' BedingterRuhezustand.vbs 1.1 von Robert Hohmann 08/2009
' Schreibt 1x pro Minute eine Datei in das Verzeichnis
' %PROGRAMFILES%\BedingterRuhezustand\temp.
' Nach der in BedingterRuhezustand.cfg festgelegten
' Anzahl Minuten wird ein geplanter Task erzeugt, der das
' Skript BedingterRuhezustand-Aktivieren.vbs aufruft und
' den Rechner abhngig von der Uhrzeit in den Ruhezustand
' fhrt. Erzeugt das Logfile BedingterRuhezustand.log.

On Error Resume Next

Set ShellWSH = CreateObject("Wscript.Shell")
Set fs = CreateObject("Scripting.FileSystemObject")
Set Env = ShellWSH.Environment("Process")
windir = Env("SYSTEMROOT") & "\"
programpath = Env("PROGRAMFILES") & "\BedingterRuhezustand\"
full_logging = 0

Randomize
zufallszahl = Int(Rnd(1)*100000000)
Set CountFile = fs.OpenTextFile(programpath & "temp\BedingterRuhezustand-" & zufallszahl & ".tmp", 8, true)  ' Datei erzeugen
CountFile.close

' Anzahl Minuten einlesen, nach denen der Rechner in den Ruhezustand gefahren werden soll
Set CfgFile = fs.OpenTextFile(programpath & "BedingterRuhezustand.cfg", 1, true)             					
Do Until CfgFile.AtEndOfStream
  zeile = Trim(CfgFile.ReadLine)
  If LCase(Trim(Left(zeile,7))) = "minuten" Then
    pos1 = InStr(zeile,"=")
    minuten = Mid(zeile,pos1+1)
    minuten = Int(minuten / 1)   ' in Zahl umwandeln
    If minuten < 3 Then minuten = 3
    If minuten > 999 Then minuten = 999
  End If
loop

If fs.fileexists(programpath & "Ruhezustand.lock") Then   ' falls Datei Ruhezustand.lock existiert
  If full_logging Then Call logging("Ruhezustand.lock vorhanden, lsche Task BedingterRuhezustand-Aktivieren und Ruhezustand.lock")
  ' Lock-Datei und Task lschen
  result = ShellWSH.Run("SCHTASKS /Delete /TN BedingterRuhezustand-Aktivieren /F")
  wscript.sleep 5000
  If not fs.fileexists(windir & "Tasks\BedingterRuhezustand-Aktivieren.job") Then fs.deletefile(programpath & "Ruhezustand.lock")  
End if

Set f = fs.GetFolder(programpath & "temp")
Set fc = f.Files
minutenzaehler = f.files.count   ' Anzahl Minuten seit letztem Ruhezustand bzw. seit Initialisierung
If minutenzaehler > minuten Then   
  fs.deletefile(programpath & "temp\*.*")   ' Zhldateien lschen
  ' gleich wieder eine neue TMP-Datei schreiben
  zufallszahl = Int(Rnd(1)*100000000)
  Set CountFile = fs.OpenTextFile(programpath & "temp\BedingterRuhezustand-" & zufallszahl & ".tmp", 8, true)  ' Datei erzeugen
  CountFile.close  
  If fs.fileexists(windir & "Tasks\BedingterRuhezustand-Aktivieren.job") Then 
    If full_logging Then Call logging("Task BedingterRuhezustand-Aktivieren bereits vorhanden")    
  Else	
    ' Task BedingterRuhezustand-FlagSetzen unter dem System-Account erzeugen
    If betriebssystem_sprache = "deutsch" Then 
      intervall = "BEILEERLAUF"
    Else
      intervall = "ONIDLE"
    End If
    Call logging("Erstelle geplanten Task, um nach " & minuten & " Minuten Leerlauf in den Ruhezustand zu fahren")
    If full_logging Then Call logging("Taskerstellung mit: SCHTASKS /CREATE /RU system /SC " & intervall & " /I " & minuten & " /TN BedingterRuhezustand-Aktivieren /TR " & Chr(34) & "wscript \" & Chr(34) & programpath & "BedingterRuhezustand-Aktivieren.vbs" & Chr(34) & Chr(34))
    result = ShellWSH.Run("SCHTASKS /CREATE /RU system /SC " & intervall & " /I " & minuten & " /TN BedingterRuhezustand-Aktivieren /TR " & Chr(34) & "wscript \" & Chr(34) & programpath & "BedingterRuhezustand-Aktivieren.vbs" & Chr(34) & Chr(34))
  End If
End If


Function betriebssystem_sprache()
  ' Erkennt, ob die Betriebssystemsprache deutsch oder englisch ist
  strComputer = "."
  Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
  Set colOperatingSystems = objWMIService.ExecQuery ("Select * from Win32_OperatingSystem")
  For Each objOperatingSystem in colOperatingSystems
    If objOperatingSystem.OSLanguage = 1031 Then betriebssystem_sprache = "deutsch"
    If objOperatingSystem.OSLanguage = 1033 Then betriebssystem_sprache = "englisch"
  Next
End Function


Sub logging(logtext)
  ' Logging in Logfile BedingterRuhezustand.log
  Set LogFile = fs.OpenTextFile(programpath & "BedingterRuhezustand.log", 8, true)  
  LogFile.writeline Date & " " & Time & "   " & logtext	
  LogFile.Close			
End Sub
