' MaschinenStopp.vbs 1.2 von Robert Hohmann 06/2009
' Fhrt Rechner, die in der Datei PCListe.txt aufgelistet
' sind, per Shutdown-Kommando herunter. Ausgenommen sind 
' Rechner, die sich in der Datei an.txt oder in der Datei
' Exclude.txt befinden.


Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8
Dim PC(5000)
Dim Mac(5000)
Dim Exclude_PC(5000)
Dim Include_PC(5000)

pos1 = InstrRev(WScript.ScriptFullName, "\")
path = Left(WScript.ScriptFullName, pos1)

Set fs = CreateObject("Scripting.FileSystemObject")
Set ShellWSH = CreateObject("Wscript.Shell")
Set LogFile = fs.OpenTextFile(path & "log\MaschinenStopp.log", 8, true)   ' allgemeines Logfile		
Set PCListe = fs.OpenTextFile(path & "PCListe.txt", 1, true)              ' Datei mit allen PCs					
Set ExcludeFile = fs.OpenTextFile(path & "Exclude.txt", 1, true)	  ' Rechner, die nicht heruntergefahren werden sollen				
Set IncludeFile = fs.OpenTextFile(path & "Include.txt", 1, true)	  ' Rechner, die unabhngig vom urspr. Zustand heruntergefahren werden sollen
Set CfgFile = fs.OpenTextFile(path & "MaschinenStopp.cfg", 1, true)       ' Konfigurationsdatei


' MaschinenStopp.cfg einlesen
Do Until CfgFile.AtEndOfStream
  zeile = Trim(CfgFile.ReadLine)
  If Left(zeile,1) <> "#" Then   ' Kommentar
    If LCase(Left(zeile,14)) = "alwaysshutdown" Then
      pos1 = InStr(zeile, "=")
      alwaysshutdown = LCase(Trim(Mid(zeile,pos1+1)))
    End If
    If LCase(Left(zeile,13)) = "shutdowndelay" Then
      pos1 = InStr(zeile, "=")
      shutdowndelay = LCase(Trim(Mid(zeile,pos1+1)))
      If shutdowndelay > 600 Then shutdowndelay = 600
    End If
    If LCase(Left(zeile,9)) = "pingcount" Then
      pos1 = InStr(zeile, "=")
      pingcount = LCase(Trim(Mid(zeile,pos1+1)))
    End If
    If LCase(Left(zeile,11)) = "pingtimeout" Then
      pos1 = InStr(zeile, "=")
      pingtimeout = LCase(Trim(Mid(zeile,pos1+1)))
    End If    
  End If
loop


' PCs einlesen in das Array PC()
anzahl_pc = 0
Do Until PCListe.AtEndOfStream
  zeile = Trim(PCListe.ReadLine)
  If Len(zeile) > 10 and Left(zeile,1) <> "#" Then 
      anzahl_pc = anzahl_pc + 1
    ' PC-Name rausfiltern
    leerzeichen = Instr(1, zeile, " ")
    tabulator = Instr(1, zeile, Chr(9))
    If leerzeichen > 0 or tabulator > 0 Then
      If leerzeichen > 0 Then trennung = leerzeichen 
      If tabulator > 0 Then trennung = tabulator 
      PC(anzahl_pc) = Left(zeile,trennung - 1)
    End If

    ' Mac-Adresse rausfiltern
    leerzeichen = InStrRev(zeile, " ")
    tabulator = InStrRev(zeile, Chr(9))
    If leerzeichen > 0 or tabulator > 0 Then
      If leerzeichen > 0 Then trennung = leerzeichen 
      If tabulator > 0 Then trennung = tabulator 
      Mac(anzahl_pc) = Right(zeile,Len(zeile) - trennung)
    End If

  End If
loop

' Exclude-PCs einlesen()
anzahl_exclude_pc = 0
Do Until ExcludeFile.AtEndOfStream
  zeile = Trim(ExcludeFile.ReadLine)
  If Len(zeile) > 1 Then 
    anzahl_exclude_pc = anzahl_exclude_pc + 1
    Exclude_PC(anzahl_exclude_pc) = zeile
  End If
loop

' Include-PCs einlesen()
anzahl_include_pc = 0
Do Until IncludeFile.AtEndOfStream
  zeile = Trim(IncludeFile.ReadLine)
  If Len(zeile) > 1 Then 
    anzahl_include_pc = anzahl_include_pc + 1
    Include_PC(anzahl_include_pc) = zeile
  End If
loop


Call logging("======================================")


Set AnFile = fs.OpenTextFile(path&"log\an.txt", 1, true)   ' PCs aus an.log werden nicht ausgeschaltet, weil sie vorher an waren
Do While Not AnFile.AtEndOfStream
  Ergebnis = AnFile.Readall   ' alles aus AnFile in Variable Ergebnis einlesen
Loop

For i = 1 to anzahl_pc	
  ausschalt_modus = 1   ' PC ausschalten
  If instr(Ergebnis, PC(i)) > 0 Then ausschalt_modus = 2   ' PC nicht aussschalten, da vorher an
  If alwaysshutdown = "yes" Then ausschalt_modus = -1   ' PC ausschalten, da AlwaysShutdown=yes
  For k = 1 to anzahl_include_pc
    If LCase(PC(i)) = LCase(Include_PC(k)) Then ausschalt_modus = 0   ' PC aussschalten, da in Include-Liste
  Next
  For j = 1 to anzahl_exclude_pc
    If LCase(PC(i)) = LCase(Exclude_PC(j)) Then ausschalt_modus = 3   ' PC nicht aussschalten, da in Exclude-Liste
  Next
  If ausschalt_modus <= 1 Then
  If PingOK(PC(i)) Then
    shutdown = "shutdown -s -f -m " & PC(i) & " -t " & shutdowndelay & " -c " & Chr(34) & "MaschinenStopp" & Chr(34)
    Return = ShellWSH.Run(shutdown,0,True) 
    If ausschalt_modus = 1 or ausschalt_modus = -1 Then Call logging(PC(i) & " wird heruntergefahren.")
    If ausschalt_modus = 0 Then Call logging(PC(i) & " wird heruntergefahren, da er in der Include-Liste vorhanden ist.")
  Else
      Call logging(PC(i) & " ist bereits heruntergefahren.")
    End if		  
  End if
  If ausschalt_modus = 2 Then Call logging(PC(i) & " wird nicht heruntergefahren, da er vorher eingeschaltet war.")
  If ausschalt_modus = 3 Then Call logging(PC(i) & " wird nicht heruntergefahren, da er in der Exclude-Liste vorhanden ist.")
Next


Sub logging(logtext)
  ' Logging in allgemeines Logfile MaschinenStopp.log
  LogFile.writeline Date & " " & Time & "   " & logtext				
End Sub


Function PingOK(rechner)
  ' Prft per Standard-Ping, ob der bergebene Rechner eingeschaltet ist
  Pingtest = "%comspec% /c ping.exe -4 -n " & pingcount & " -w " & pingtimeout & " -a" & " " & rechner & " " & ">" & path & "temp.txt"   ' PC anpingen, Ergebnis in temp.txt schreiben	
  result = ShellWSH.Run(Pingtest,0,True) 
  Set TempFile = fs.OpenTextFile(path & "temp.txt")       
  PingErgebnis = Tempfile.Readall   ' Alles aus Tempfile in Variable PingErgebnis einlesen
  If instr(PingErgebnis, "ytes=") > 0 Then   ' PC ist an	
    PingOK = 1
  Else   ' PC ist aus
    PingOK = 0
  End If
End Function
