' WakeupService.vbs 1.1 von Robert Hohmann 06/2009
' Fhrt Rechner, die sich im Unterverzeichnis PCs befinden,
' per Wake-On-Lan hoch. Muss per Scheduled Task 1x pro
' Minute gestartet werden. Feiertage werden in der Datei
' Exclude.txt festgelegt. Um das Wake-On-Lan-Signal
' ber Routergrenzen hinweg zu senden, muss die Broadcast-
' Adresse in WakeupService.cfg eingetragen werden.

On Error Resume Next

Dim wochentage(7)
Dim masks(100)
Public PingErgebnis
Public byte1, byte2, byte3, byte4

wochentage(1) = "Sonntag"
wochentage(2) = "Montag"
wochentage(3) = "Dienstag"
wochentage(4) = "Mittwoch"
wochentage(5) = "Donnerstag"
wochentage(6) = "Freitag"
wochentage(7) = "Samstag"

pos1 = InstrRev(WScript.ScriptFullName, "\")
path = Left(WScript.ScriptFullName, pos1)
pcpath = path & "PCs\"
datum = Date 
zeit = Left(Time,5)
wochentag = wochentage(Weekday(Datum))

Dim fso, f, f1, fc
Set fso = CreateObject("Scripting.FileSystemObject")
Set f = fso.GetFolder(pcpath)
Set fc = f.Files
Set Shell = CreateObject("Wscript.Shell")
Set LogFile = fso.OpenTextFile(path & "\WakeupService.log", 8, true)       ' allgemeines Logfile
Set ExcludeFile = fso.OpenTextFile(path & "\Exclude.txt", 1, true)         ' Feiertage
Set CfgFile = fso.OpenTextFile(path & "WakeupService.cfg", 1, true)        ' Konfigurationsdatei


' WakeupService.cfg einlesen
anzahl_masks = 0
Do Until CfgFile.AtEndOfStream
  zeile = Trim(CfgFile.ReadLine)
  If Left(zeile,1) <> "#" Then   ' Kommentare mit #
    If LCase(Left(zeile,10)) = "subnetmask" Then
      anzahl_masks = anzahl_masks + 1
      pos1 = InStr(zeile, "=")
      masks(anzahl_masks) = Trim(Mid(zeile,pos1+1))
    End If
  End If
loop


feiertag = 0
Do Until ExcludeFile.AtEndOfStream   ' Exclude.txt lesen
  zeile = Trim(ExcludeFile.ReadLine)
  If Len(zeile) > 4 and IsDate(zeile) Then zeile = CDate(zeile)
  If zeile = datum Then feiertag = 1
loop

 
For Each f1 in fc   ' PC-Files auflisten
  Set PCFile = fso.OpenTextFile(pcpath & f1.name, 1, true)					
  aufwecken = 0
  zeilennummer = 1
  Do Until PCFile.AtEndOfStream   ' in PC-Files lesen
    zeile = Trim(PCFile.ReadLine)
    If zeilennummer = 1 Then 
      mac = Left(zeile,12)
      pos1 = InStrRev(zeile," ")
      host = Mid(zeile,14,pos1-14)
      user = Trim(Mid(zeile,pos1+1))
    End If
    If Left(zeile,Len(wochentag)) = wochentag Then
      If Right(zeile,1) = "1" Then
        pos1 = InStr(zeile,"|")
        pos2 = InStr(zeile,"/")
        weckzeit = Mid(zeile,pos1+1,pos2-pos1-1)          
        If weckzeit = zeit Then aufwecken = 1
      End If 
    End If 
    ' Ausnahme durch Anwender erstellt:
    If aufwecken = 1 and zeilennummer = 9 and Right(zeile,1) = "1" Then    
      ausnahmetag = Left(zeile,10)
      ausnahmetag = CDate(ausnahmetag)
      pos1 = InStr(zeile,"|")
      ausnahmedauer = Mid(zeile,pos1 + 1,2)
      If datum >= ausnahmetag and datum <= ausnahmetag + ausnahmedauer - 1 Then 
      	aufwecken = 0
        Call logging(host & " wird heute nicht geweckt - Ausnahme definiert von Benutzer " & Trim(user) & "=> ab " & ausnahmetag & " fuer " & ausnahmedauer & " Tag(e)")
      End if
    End If
    If feiertag = 1 Then
      If Left(Trim(LCase(zeile)),18) = "weckenanfeiertagen" Then
        If Right(Trim(LCase(zeile)),1) = "1" and aufwecken = 1 Then aufwecken = 2
      End If
    End if
    zeilennummer = zeilennummer + 1  
  Loop
  
  If aufwecken > 0 Then   ' kann auch 2 sein --> auch am Feiertag wecken
    If feiertag = 0 or aufwecken = 2 Then 
      If PingOK(host) Then									
        an = 1
        Call logging(host & " ist bereits eingeschaltet." )					
      Else
        an = 0									
        result = shell.Run(path & "\wol.exe " & mac, 0, True)
        Call logging("Wecke " & host & " mit der Mac-Adresse " & mac & " auf Anforderung von Benutzer " & user)
        ' IP-Adresse bestimmen (steht in temp.txt in eckigen Klammern und muss Punkte enthalten):
        pos1 = InStr(PingErgebnis, "[")
        pos2 = InStr(PingErgebnis, "]")
        If pos1 < pos2 Then temp = Mid(PingErgebnis, pos1+1, pos2-pos1-1)
        If pos1 < pos2 and InStr(temp, ".") > 1 Then 
          ip = temp
        Else
          ip = "keine IP"  
        End If 
        If ip <> "keine IP" Then
          For j = 1 to anzahl_masks
            ' aus Kombination IP-Adresse + Subnetzmaske die Broadcastadresse bestimmen:
            x = GetBytes(masks(j))
            maskbyte1 = byte1 xor 255
            maskbyte2 = byte2 xor 255
            maskbyte3 = byte3 xor 255
            maskbyte4 = byte4 xor 255
            x = GetBytes(ip)
            broadcastbyte1 = byte1 or maskbyte1
            broadcastbyte2 = byte2 or maskbyte2
            broadcastbyte3 = byte3 or maskbyte3
            broadcastbyte4 = byte4 or maskbyte4
            broadcast = broadcastbyte1 & "." & broadcastbyte2 & "." & broadcastbyte3 & "." & broadcastbyte4
            Call logging("...zusaetzlicher Weckversuch mit IP-Broadcast " & broadcast)					
            result = shell.Run(path & "wol.exe " & mac & " " & broadcast, 0 ,True)		
          Next
        End If
      End If
    Else
      Call logging(host & " wird heute nicht geweckt wg. Feiertag")    
    End If
  End If
Next ' Hauptschleife


Sub logging(logtext)
  ' Logging in allgemeines Logfile WakeupService.log
  LogFile.writeline Date & " " & Time & "   " & logtext
End Sub


Function PingOK(rechner)
  ' Prft per Standard-Ping, ob der bergebene Rechner eingeschaltet ist
  Pingtest = "%comspec% /c ping.exe -4 -n 1 -w 500 -a" & " " & rechner & " " & ">" & path & "temp.txt"   ' PC anpingen, Ergebnis in temp.txt schreiben	
  result = shell.Run(Pingtest,0,True) 
  Set TempFile = fso.OpenTextFile(path & "temp.txt")       
  PingErgebnis = Tempfile.Readall   ' Alles aus Tempfile in Variable PingErgebnis einlesen
  If instr(PingErgebnis, "ytes=") > 0 Then   ' PC ist an	
    PingOK = 1
  Else   ' PC ist aus
    PingOK = 0
  End If
End Function


Function GetBytes(my_ip)
  ' Zerlegt IP-Adress-String in einzelne Bytes
  my_ip = Trim(my_ip)
  pos1 = InStr(my_ip, ".")
  pos3 = InStrRev(my_ip, ".")
  temp = Left(my_ip, pos3-1)
  pos2 = InStrRev(temp, ".")
  byte1 = Left(my_ip, pos1-1)
  byte2 = Mid(my_ip, pos1+1, pos2-pos1-1)
  byte3 = Mid(my_ip, pos2+1, pos3-pos2-1)
  byte4 = Mid(my_ip, pos3+1)  
End Function