<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: urls.php c3264c41b61d 2009/10/15 15:26:27 Oliver Lau <oliver@von-und-fuer-lau.de> $
header('Content-type: text/x-json');
include('../globals.inc.php');

$d = '';
$fp = fopen('php://input', 'rb');
while (!feof($fp))
    $d .= fread($fp, 512);
fclose($fp);
if (!get_magic_quotes_gpc())
    $d = stripslashes($d);
$jsonArray = json_decode($d);

if (!$jsonArray) {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Invalid or missing data.',
          'data' => $d
         ));
    exit;
}

$dbh = dbpconnect('.');

$urlmappings = array();

$sql = 'SELECT origin, destination FROM urlmappings WHERE origin = ?';
$sth = $dbh->prepare($sql);

foreach($jsonArray as $id) {
   $rs = $sth->execute(array($id));
   if (!$rs) {
       echo json_encode(array(
             'status' => E_INVALID_REQUEST,
             'message' => 'sth->execute() failed.',
             'data' => $d
            ));
       exit;
   }
   while ($row = $sth->fetch(PDO::FETCH_ASSOC))
     array_push($urlmappings, array(
         'origin' => $row['origin'],
         'destination' => $row['destination']
     ));
}
    
print json_encode($urlmappings);

?>