<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: tweets.php f5c9a6e80742 2009/10/16 09:18:54 Oliver Lau <oliver@von-und-fuer-lau.de> $
header('Content-type: text/x-json');
include('../globals.inc.php');

$d = '';
$fp = fopen('php://input', 'rb');
while (!feof($fp))
    $d .= fread($fp, 512);
fclose($fp);
if (!get_magic_quotes_gpc())
    $d = stripslashes($d);
$jsonArray = json_decode($d);

if (!$jsonArray) {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Invalid or missing data.',
          'data' => $d
         ));
    exit;
}

$dbh = dbpconnect('.');

$tweets = array();

$dbh->exec('BEGIN TRANSACTION');
$sql = 'SELECT id, user_id, user_screen_name, user_name, created_at, tweet, in_reply_to_screen_name, in_reply_to_status_id FROM tweets WHERE id = ?';
$sth = $dbh->prepare($sql);

foreach($jsonArray as $id) {
   $rs = $sth->execute(array($id));
   if (!$rs) {
       echo json_encode(array(
             'status' => E_INVALID_REQUEST,
             'message' => 'sth->execute() failed.',
             'data' => $d
            ));
       exit;
   }
   while ($row = $sth->fetch(PDO::FETCH_ASSOC))
     array_push($tweets, array(
         'id' => $row['id'],
         'user' => array(
                         'id' => $row['user_id'],
                         'screen_name' => $row['user_screen_name'],
                         'name' => $row['user_name']
                        ),
         'created_at' => $row['created_at'],
         'tweet' => $row['tweet'],
         'in_reply_to_screen_name' => $row['in_reply_to_screen_name'],
         'in_reply_to_status_id' => $row['in_reply_to_status_id']
     ));
}
$dbh->exec('END TRANSACTION');

print json_encode($tweets);

?>