<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: ids.php 8b73b177f0d5 2009/10/16 08:52:02 Oliver Lau <oliver@von-und-fuer-lau.de> $
header('Content-type: text/x-json');

include('../globals.inc.php');

$dbh = dbpconnect('.');

$ids = array(
    'tweets' => array(),
    'urlmappings' => array(),
    'posts' => array(),
    'pics' => array()
);

//////////////////////////////////////////////////////////////////////
//
// Alle IDs mssen aufsteigend sortiert sein, damit die optimierte
// Restmengenbildung in twitterbak.pl funktioniert.
//
//////////////////////////////////////////////////////////////////////

$res = $dbh->query('SELECT id FROM tweets ORDER BY id ASC', PDO::FETCH_ASSOC);
if ($res)
    foreach($res as $row)
        array_push($ids['tweets'], $row['id']);

$res = $dbh->query('SELECT origin FROM urlmappings ORDER BY origin ASC', PDO::FETCH_ASSOC);
if ($res)
    foreach($res as $row)
        array_push($ids['urlmappings'], $row['origin']);

$res = $dbh->query('SELECT id FROM posts ORDER BY id ASC', PDO::FETCH_ASSOC);
if ($res)
	foreach($res as $row)
 		array_push($ids['posts'], $row['id']);

$picDir = '..';
// glob() sortiert die Dateinamen automatisch in aufsteigender Reihenfolge
foreach (glob("$picDir/*.jpg") as $filename)
    array_push($ids['pics'], basename($filename));
   
print json_encode($ids);
?>