<?php
// Copyright (c) 2009 Oliver Lau <oliver@von-und-fuer-lau.de>
// All rights reserved.
// $Id: addurl.php 429b7fc28d80 2009/10/09 12:49:20 Oliver Lau <oliver@von-und-fuer-lau.de> $
header('Content-type: text/x-json');
include('../globals.inc.php');

$d = '';
$fp = fopen('php://input', 'rb+');
while (!feof($fp))
    $d .= fread($fp, 4096);
fclose($fp);
if (!get_magic_quotes_gpc())
    $d = stripslashes($d);
$jsonArray = json_decode($d);

if (!$jsonArray) {
    echo json_encode(array(
          'status' => E_INVALID_REQUEST,
          'message' => 'Invalid or missing data.',
          'data' => $d
         ));
    exit;
}

$dbh = dbpconnect('.');
if (!$dbh) {
    echo json_encode(array(
          'status' => E_UNAVAILABLE,
          'message' => 'Cannot connect to database.',
          'data' => $d
         ));
    exit;
}

$sth = $dbh->prepare('INSERT OR REPLACE INTO urlmappings (origin, destination) VALUES (?, ?)');
foreach ($jsonArray as $json) {
    $rs = $sth->execute(array($json->{'origin'}, $json->{'destination'}));
    if (!$rs) {
       echo json_encode(array(
             'status' => E_INVALID_REQUEST,
             'message' => 'sth->execute() failed.',
             'data' => $d
            ));
       exit;
    }
}

echo json_encode(array(
    'status' => E_OK,
    'message' => count($jsonArray) . " URL-Mappings hinzugefügt/ersetzt.",
    'data' => ''
     ));
?>