﻿// PNRP Beacon - Ein PNRP Beispielprogramm
// benoetigt .NET Runtime 3.5 SP1 oder neuer
// Windows 2008 Server oder Vista mit PNRP 
// IPv6 Netzwerkanbindung
//
// 12/2008 Carsten Strotmann
// (c) 2008 c't Magazin, Heise Verlag
//

using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;
using System.Net;
using System.Net.PeerToPeer;
using System.Threading;

namespace PnrpBeacon
{
    // Datenstruktur zum Verwalten von PNRP-Beacon Topics
    internal class PnrpTopic : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler PropertyChanged;

        // Aenderungen per Event an die UI (WPF) weitergeben
        protected void Notify(String propName)
        {
            if (this.PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propName));
            }
        }

        // Topic Name
        private string name;
        public string Name {
            get { return this.name; }
            set { 
                this.name = value;
                Notify("Name");
            }
        }
        
        // gefundene Endpoints fuer das Topic
        private Hashtable peers;
        public Hashtable Peers {
            get { return this.peers; }
            set { 
                this.peers = value;
                Notify("Peers");
            }
        }

        // pruefen, ob ein Endpoint schon bekannt ist
        public Boolean hasEndpoint(EndPoint endpoint) {
            return this.peers.Contains(endpoint);
        }

        // neuen Endpoint hinzufuegen
        public void addEndpoint(EndPoint endpoint, string comment)
        {
            this.peers.Add(endpoint, comment);
        }

        // Konstruktoren
        public PnrpTopic( ) {}
        public PnrpTopic(string name) {
            this.name = name;
            this.peers = new Hashtable();
        }
    }

    // Eine Collection aus Topic-Eintraegen
    // kann per Data-Binding an eine UI-Liste
    // gekoppelt werden
    internal class PnrpTopics : ObservableCollection<PnrpTopic> {
    
        // erstellt eine volle Kopie der Topics 
        // Datenstruktur (keine Referenz)
        public PnrpTopics clone()
        {
            PnrpTopics clone = new PnrpTopics();
            IEnumerator enumerator = this.GetEnumerator();
            while (enumerator.MoveNext())
            {
                clone.Add((PnrpTopic)enumerator.Current);
            }

            return clone;
        }

        // pruefen, ob ein Topic schon in der Datenstruktur
        // vorhanden ist
        public Boolean ContainsTopic(String topicname)
        {
            Boolean flag = false;
            IEnumerator enumerator = this.GetEnumerator();
            while (!flag && enumerator.MoveNext())
            {
                PnrpTopic topic = (PnrpTopic) enumerator.Current;
                flag = topic.Name.Equals(topicname);
            }
            return flag;
        }

        // ein Topic Objekt anhand des Topicnamens finden
        public PnrpTopic getTopicbyName(String topicname)
        {
            PnrpTopic topic = null;
            IEnumerator enumerator = this.GetEnumerator();
            while (topic == null && enumerator.MoveNext())
            {
                PnrpTopic ntopic = (PnrpTopic)enumerator.Current;
                if (ntopic.Name.Equals(topicname))
                    topic = ntopic;
            }
            return topic;
        }
    }
}
