{type:"class",attributes:{"name":"ObjectPool","packageName":"qx.util","superClass":"qx.core.Object","childClasses":"qx.event.Pool","fullName":"qx.util.ObjectPool","type":"class"},children:[{type:"desc",attributes:{"text":"<p>This class manages pooled Object instances.</p>\n\n<p>It exists mainly to minimise the amount of browser memory usage by reusing\nwindow instances after they have been closed.  However, it could equally be\nused to pool instances of any type of Object (expect singletons).</p>\n\n<p>It is the client&#8217;s responsibility to ensure that pooled objects are not\nreferenced or used from anywhere else in the application.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"size"},children:[{type:"desc",attributes:{"text":"<p>Size of each class pool</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"name":"getObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"clazz"},children:[{type:"desc",attributes:{"text":"<p>A reference to a class from which an instance should be created.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Class"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method finds and returns an instance of a requested type in the pool,\nif there is one.  Note that the pool determines which instance (if any) to\nreturn to the client.  The client cannot get a specific instance from the\npool.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>An instance of the requested type. If non existed in the pool a new\n  one is transparently created and returned.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"name":"getSize","fromProperty":"size"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>size</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSize","fromProperty":"size"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>size</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>size</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"poolObject"},children:[{type:"params",children:[{type:"param",attributes:{"name":"obj"},children:[{type:"desc",attributes:{"text":"<p>An Object instance to pool.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method places an Object in a pool of Objects of its type. Note that\nonce an instance has been pooled, there is no means to get that exact\ninstance back. The instance may be discarded for garbage collection if\nthe pool of its type is already full.</p>\n\n<p>It is assumed that no other references exist to this Object, and that it will\nnot be used at all while it is pooled.</p>"}}]},{type:"method",attributes:{"name":"resetSize","fromProperty":"size"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>size</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setSize","fromProperty":"size"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>size</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>size</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #size}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Integer","allowNull":"true","defaultValue":"null","name":"size","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Number of objects of each class, which are pooled.</p>\n\n<p>A size of &#8220;null&#8221; represents an unlimited pool.</p>"}}]}]}]}