{type:"class",attributes:{"name":"MDesktop","packageName":"qx.ui.window","includer":"qx.ui.root.Abstract,qx.ui.window.Desktop","fullName":"qx.ui.window.MDesktop","type":"mixin"},children:[{type:"desc",attributes:{"text":"<p>This mixin implements the key methods of the {@link qx.ui.window.IDesktop}.</p>"}},{type:"methods",children:[{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_addWindow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"win"},children:[{type:"desc",attributes:{"text":"<p>Window, which has been added</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.window.Window"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles the case, when a window is added to the desktop.</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_afterAddChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"win"},children:[{type:"desc",attributes:{"text":"<p>added widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Overrides the method {@link qx.core.Widget#_afterAddChild}</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_afterRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"win"},children:[{type:"desc",attributes:{"text":"<p>removed widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Overrides the method {@link qx.core.Widget#_afterRemoveChild}</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.window.MDesktop#activeWindow","isMixin":"true","name":"_applyActiveWindow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.window.Window"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.window.Window"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>activeWindow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyActiveWindow}.</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_onChangeActive"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>the event object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called if one of the managed windows changes its active\nstate.</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_onChangeModal"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>the event object.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler. Called if one of the managed windows changes its modality</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_onChangeVisibility"},children:[{type:"desc",attributes:{"text":"<p>Event handler. Called if one of the managed windows changes its visibility\nstate.</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_removeWindow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"win"},children:[{type:"desc",attributes:{"text":"<p>Window, which has been removed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.window.Window"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles the case, when a window is removed from the desktop.</p>"}}]},{type:"method",attributes:{"name":"getActiveWindow","fromProperty":"activeWindow"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>activeWindow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #activeWindow}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>activeWindow</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"getWindowManager"},children:[{type:"desc",attributes:{"text":"<p>Get the desktop&#8217;s window manager. Each desktop must have a window manager.\nIf none is configured the default window manager {@link qx.ui.window.Window#DEFAULT_MANAGER_CLASS}\nis used.</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"getWindows"},children:[{type:"desc",attributes:{"text":"<p>Get a list of all windows added to the desktop (including hidden windows)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Array of managed windows</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.window.Window","dimensions":"1"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initActiveWindow","fromProperty":"activeWindow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>activeWindow</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>activeWindow</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #activeWindow}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetActiveWindow","fromProperty":"activeWindow"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>activeWindow</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #activeWindow}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setActiveWindow","fromProperty":"activeWindow"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>activeWindow</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>activeWindow</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #activeWindow}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"setWindowManager"},children:[{type:"params",children:[{type:"param",attributes:{"name":"manager"},children:[{type:"desc",attributes:{"text":"<p>The window manager</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.window.IWindowManager"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the desktop&#8217;s window manager</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"supportsMaximize"},children:[{type:"desc",attributes:{"text":"<p>Whether the configured layout supports a maximized window\ne.g. is a Canvas.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the layout supports maximized windows</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"qx.ui.window.Window","apply":"_applyActiveWindow","isMixin":"true","name":"activeWindow","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The currently active window</p>"}}]}]}]}