{type:"class",attributes:{"name":"Manager","packageName":"qx.ui.menu","superClass":"qx.core.Object","isSingleton":"true","fullName":"qx.ui.menu.Manager","type":"class"},children:[{type:"desc",attributes:{"text":"<p>This singleton manages visible menu instances and supports some\ncore features to schedule menu open/close with timeout support.</p>\n\n<p>It also manages the whole keyboard support for the currently\nregistered widgets.</p>\n\n<p>The zIndex order is also managed by this class.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"}}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","name":"_getChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>Any menu instance</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]},{type:"param",attributes:{"name":"start"},children:[{type:"desc",attributes:{"text":"<p>Child index to start with</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"iter"},children:[{type:"desc",attributes:{"text":"<p>Iteration count, normally <code>+1</code> or <code>-1</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"loop"},children:[{type:"desc",attributes:{"text":"<p>Whether to wrap when reaching the begin/end of the list</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Query engine for menu children.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Any menu button or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Button"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_isInMenu"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>Any widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given widget is inside any Menu instance.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the widget is part of any menu"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onCloseInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Interval event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for a pending close request. Configured to the interval\nof the current menu to close.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Keyboard event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for all keypress events. Delegates the event to the more\nspecific methods defined in this class.</p>\n\n<p>Currently processes the keys: <code>Up</code>, <code>Down</code>,\n<code>Left</code>, <code>Right</code> and <code>Enter</code>.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPressDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The active menu</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for <code>Down</code> key</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPressEnter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The active menu</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]},{type:"param",attributes:{"name":"button"},children:[{type:"desc",attributes:{"text":"<p>The selected button</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.AbstractButton"}}]}]},{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The keypress event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for <code>Enter</code> key</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPressLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The active menu</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for <code>Left</code> key</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPressRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The active menu</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for <code>Right</code> key</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPressSpace"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The active menu</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]},{type:"param",attributes:{"name":"button"},children:[{type:"desc",attributes:{"text":"<p>The selected button</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.AbstractButton"}}]}]},{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The keypress event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for <code>Space</code> key</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyPressUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The active menu</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for <code>Up</code> key</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onKeyUpDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Keyboard event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for all keyup/keydown events. Stops all events\nwhen any menu is opened.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mousedown event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for mousedown events</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseup event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for mouseup events</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onOpenInterval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Interval event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for a pending open request. Configured to the interval\nof the current menu to open.</p>"}}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"obj"},children:[{type:"desc",attributes:{"text":"<p>Any menu instance.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a menu to the list of visible menus.</p>"}}]},{type:"method",attributes:{"name":"cancelClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The menu to cancel for close</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>When the given menu is scheduled for close this pending\nrequest is canceled.</p>"}}]},{type:"method",attributes:{"name":"cancelOpen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The menu to cancel for open</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>When the given menu is scheduled for open this pending\nrequest is canceled.</p>"}}]},{type:"method",attributes:{"name":"getActiveMenu"},children:[{type:"desc",attributes:{"text":"<p>Returns the menu which was opened at last (which\nis the active one this way)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The current active menu or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"method",attributes:{"name":"hideAll"},children:[{type:"desc",attributes:{"text":"<p>Hides all currently opened menus.</p>"}}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"obj"},children:[{type:"desc",attributes:{"text":"<p>Any menu instance.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove a menu from the list of visible menus.</p>"}}]},{type:"method",attributes:{"name":"scheduleClose"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The menu to schedule for close</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Schedules the given menu to be closed after the\n{@link qx.ui.menu.Menu#closeInterval} configured by the\nmenu instance itself.</p>"}}]},{type:"method",attributes:{"name":"scheduleOpen"},children:[{type:"params",children:[{type:"param",attributes:{"name":"menu"},children:[{type:"desc",attributes:{"text":"<p>The menu to schedule for open</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Menu"}}]}]}]},{type:"desc",attributes:{"text":"<p>Schedules the given menu to be opened after the\n{@link qx.ui.menu.Menu#openInterval} configured by the\nmenu instance itself.</p>"}}]}]},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"getInstance"},children:[{type:"desc",attributes:{"text":"<p>Returns a singleton instance of this class. On the first call the class\nis instantiated by calling the constructor with no arguments. All following\ncalls will return this instance.</p>\n\n<p>This method has been added by setting the &#8220;type&#8221; key in the class definition\n({@link qx.Class#define}) to &#8220;singleton&#8221;.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The singleton instance of this class.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.menu.Manager"}}]}]}]}]}]}