{type:"class",attributes:{"isAbstract":"true","name":"Abstract","packageName":"qx.ui.layout","superClass":"qx.core.Object","childClasses":"qx.ui.layout.Atom,qx.ui.layout.Basic,qx.ui.layout.Canvas,qx.ui.layout.Dock,qx.ui.layout.Grid,qx.ui.layout.Grow,qx.ui.layout.HBox,qx.ui.layout.VBox,qx.ui.menu.ButtonLayout,qx.ui.splitpane.HLayout,qx.ui.splitpane.VLayout","fullName":"qx.ui.layout.Abstract","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Base class for all layout managers.</p>\n\n<p>Custom layout manager must derive from\nthis class and implement the methods {@link #invalidateLayoutCache},\n{@link #renderLayout} and {@link #getSizeHint}.</p>"}},{type:"methods",children:[{type:"method",attributes:{"access":"protected","name":"_applyLayoutChange"},children:[{type:"desc",attributes:{"text":"<p>Indicate that the layout has layout changed and propagate this information\nup the widget hierarchy.</p>\n\n<p>Also a generic property apply method for all layout relevant properties.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_clearSeparators"},children:[{type:"desc",attributes:{"text":"<p>Remove all currently visible separators</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_computeSizeHint"},children:[{type:"desc",attributes:{"text":"<p>This computes the size hint of the layout and returns it.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The size hint.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getLayoutChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns the list of all layout relevant children.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of layout relevant children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_renderSeparator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"separator"},children:[{type:"desc",attributes:{"text":"<p>The separator to render</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Separator"}}]}]},{type:"param",attributes:{"name":"bounds"},children:[{type:"desc",attributes:{"text":"<p>Contains the left and top coordinate and the width and height\n   of the separator to render.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Renders a separator between two children</p>"}}]},{type:"method",attributes:{"name":"connectToWidget"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to connect to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method is called by the widget to connect the widget with the layout.</p>"}}]},{type:"method",attributes:{"name":"getHeightForWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>The computed width</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>If layout wants to trade height for width it has to implement this\nmethod and return the preferred height if it is resized to\nthe given width. This function returns <code>null</code> if the item\ndo not support height for width.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The desired height</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getSizeHint"},children:[{type:"desc",attributes:{"text":"<p>Computes the layout dimensions and possible ranges of these.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The map with the preferred width/height and the allowed\n  minimum and maximum values in cases where shrinking or growing\n  is required. Can also return <code>null</code> when this detection\n  is not supported by the layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"hasHeightForWidth"},children:[{type:"desc",attributes:{"text":"<p>Whether the layout manager supports height for width.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the layout manager supports height for width</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"invalidateChildrenCache"},children:[{type:"desc",attributes:{"text":"<p>This method is called, on each child &#8220;add&#8221; and &#8220;remove&#8221; action and\nwhenever the layout data of a child is changed. The method should be used\nto clear any children relevant cached data.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"invalidateLayoutCache"},children:[{type:"desc",attributes:{"text":"<p>Invalidate all layout relevant caches. Automatically deletes the size hint.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"renderLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"availWidth"},children:[{type:"desc",attributes:{"text":"<p>Final width available for the content (in pixel)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"availHeight"},children:[{type:"desc",attributes:{"text":"<p>Final height available for the content (in pixel)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies the children layout.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"verifyLayoutProperty"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>The affected layout item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"name"},children:[{type:"desc",attributes:{"text":"<p>Name of the layout property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Value of the layout property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Verifies the value of a layout property.</p>\n\n<p>Note: This method is only available in the debug builds.</p>"}}]}]}]}