{type:"class",attributes:{"name":"IDecorator","packageName":"qx.ui.decoration","implementations":"qx.ui.decoration.Uniform,qx.ui.decoration.Background,qx.ui.decoration.Grid,qx.ui.decoration.Single,qx.ui.decoration.Beveled","fullName":"qx.ui.decoration.IDecorator","type":"interface"},children:[{type:"desc",attributes:{"text":"<p>A decorator is responsible for rendering a widget&#8217;s background and\nborder. It is passed the widget&#8217;s decoration element {@link qx.html.Element}\nand configures it to display the decoration.</p>\n\n<p>A {@link qx.html.Element} can be initialized for usage calling the\nmethod {@link #init} and given the element as a parameter.</p>\n\n<p>Later elements are updated using the decorator methods {@link #resize}\nand {@link #tint} to scale and tint the element to the local\nconfiguration of the widget.</p>"}},{type:"methods",children:[{type:"method",attributes:{"name":"getInsets"},children:[{type:"desc",attributes:{"text":"<p>Get the amount of space, the decoration needs for its border on each\nside.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the desired insed a map with the keys <code>top</code>,\n    <code>right</code>, <code>bottom</code>, <code>left</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getMarkup"},children:[{type:"desc",attributes:{"text":"<p>Returns the basic markup structure used for this decoration.\nThis later updated on <span class=\"caps\">DOM</span> to resize or tint the element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Basic markup</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"init"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element to initialize</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Initialized the given element for being used\nas a decorator element.</p>"}}]},{type:"method",attributes:{"name":"resize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element to update</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>Width of the element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"height"},children:[{type:"desc",attributes:{"text":"<p>Height of the element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Resizes the element respecing the configured borders\nto the given width and height. Should automatically\nrespect the box model of the client to correctly\ncompute the dimensions.</p>"}}]},{type:"method",attributes:{"name":"tint"},children:[{type:"params",children:[{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p>The element to update</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]},{type:"param",attributes:{"name":"bgcolor"},children:[{type:"desc",attributes:{"text":"<p>The color to apply or <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies the given background color to the element\nor fallback to the background color defined\nby the decoration itself.</p>"}}]}]}]}