{type:"class",attributes:{"isStatic":"true","name":"Layout","packageName":"qx.ui.core.queue","fullName":"qx.ui.core.queue.Layout","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The layout queue manages all widgets, which need a recalculation of their\nlayout. The {@link #flush} method computes the layout of all queued widgets\nand their dependent widgets.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__getLevelGroupedWidgets"},children:[{type:"desc",attributes:{"text":"<p>Group widget by their nesting level.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A sparse array. Each entry of the array contains a widget\n    map with all widgets of the same level as the array index.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map","dimensions":"1"}}]}]}]},{type:"method",attributes:{"access":"private","isStatic":"true","name":"__getSortedQueue"},children:[{type:"desc",attributes:{"text":"<p>Compute all layout roots of the given widgets. Layout roots are either\nroot widgets or widgets, which preferred size has not changed by the\nlayout changes of its children.</p>\n\n<p>This function returns the roots ordered by their nesting factors. The\nlayout with the largest nesting level comes first.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Ordered list or layout roots.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget","dimensions":"1"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>Widget to add.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Mark a widget&#8217;s layout as invalid and add its layout root to\nthe queue.</p>\n\n<p>Should only be used by {@link qx.ui.core.Widget}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"flush"},children:[{type:"desc",attributes:{"text":"<p>Update the layout of all widgets, which layout is marked as invalid.</p>\n\n<p>This is used exclusively by the {@link qx.ui.core.queue.Manager}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getNestingLevel"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to query.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Get the widget&#8217;s nesting level. Top level widgets have a nesting level\nof <code>0</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The nesting level</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to clear</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Clears the widget from the internal queue. Normally only used\nduring interims disposes of one or a few widgets.</p>"}}]}]}]}