{type:"class",attributes:{"name":"MSelectionHandling","packageName":"qx.ui.core","includer":"qx.ui.form.List,qx.ui.tree.Tree","fullName":"qx.ui.core.MSelectionHandling","type":"mixin"},children:[{type:"desc",attributes:{"text":"<p>This mixin links all methods to manage the selection from the\ninternal selection manager to the widget.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"isCtor":"true","name":"ctor"}}]},{type:"events",children:[{type:"event",attributes:{"name":"changeSelection"},children:[{type:"desc",attributes:{"text":"<p>Fires after the selection was modified</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.MSelectionHandling#dragSelection","isMixin":"true","name":"_applyDragSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>dragSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDragSelection}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.MSelectionHandling#quickSelection","isMixin":"true","name":"_applyQuickSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>quickSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyQuickSelection}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.MSelectionHandling#selectionMode","isMixin":"true","name":"_applySelectionMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>selectionMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySelectionMode}.</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_getManager"},children:[{type:"desc",attributes:{"text":"<p>Returns the internal selection manager. Use this with\ncaution!</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The selection manager</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.selection.Abstract"}}]}]}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_onSelectionChange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Data event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for <code>change</code> event on selection manager.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"addToSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds the given item to the existing selection.</p>\n\n<p>Use {@link #selectItem} instead if you want to replace\nthe current selection.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"clearSelection"},children:[{type:"desc",attributes:{"text":"<p>Clears the whole selection at once. Also\nresets the lead and anchor items and their\nstyles.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getDragSelection","fromProperty":"dragSelection"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>dragSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dragSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>dragSelection</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getQuickSelection","fromProperty":"quickSelection"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>quickSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quickSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>quickSelection</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"getSelectedItem"},children:[{type:"desc",attributes:{"text":"<p>Get the selected item. This method does only work in <code>single</code>\nselection mode.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The selected item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"getSelection"},children:[{type:"desc",attributes:{"text":"<p>Returns an array of currently selected items.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of items.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object","dimensions":"1"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"getSelectionContext"},children:[{type:"desc",attributes:{"text":"<p>Returns the last selection context. One of <code>click</code>,\n<code>quick</code>, <code>drag</code> or <code>key</code> or\n<code>null</code>.</p>"}}]},{type:"method",attributes:{"name":"getSelectionMode","fromProperty":"selectionMode"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>selectionMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectionMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>selectionMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"getSortedSelection"},children:[{type:"desc",attributes:{"text":"<p>Returns an array of currently selected items sorted\nby their index in the container.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Sorted list of items</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object","dimensions":"1"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDragSelection","fromProperty":"dragSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>dragSelection</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>dragSelection</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #dragSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initQuickSelection","fromProperty":"quickSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>quickSelection</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>quickSelection</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #quickSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSelectionMode","fromProperty":"selectionMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>selectionMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>selectionMode</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #selectionMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isDragSelection","fromProperty":"dragSelection"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>dragSelection</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dragSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isQuickSelection","fromProperty":"quickSelection"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>quickSelection</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quickSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"isSelected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid selectable item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Detects whether the given item is currently selected.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the item is selected</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"isSelectionEmpty"},children:[{type:"desc",attributes:{"text":"<p>Whether the selection is empty</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the selection is empty</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"removeFromSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given item from the selection.</p>\n\n<p>Use {@link #clearSelection} when you want to clear\nthe whole selection at once.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"replaceSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"items"},children:[{type:"desc",attributes:{"text":"<p>Items to select</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Replaces current selection with the given items</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetDragSelection","fromProperty":"dragSelection"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>dragSelection</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #dragSelection}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetQuickSelection","fromProperty":"quickSelection"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>quickSelection</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #quickSelection}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSelectionMode","fromProperty":"selectionMode"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>selectionMode</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #selectionMode}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"select"},children:[{type:"params",children:[{type:"param",attributes:{"name":"item"},children:[{type:"desc",attributes:{"text":"<p>Any valid item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Selects the given item. Replaces current selection\ncompletely with the new item.</p>\n\n<p>Use {@link #addToSelection} instead if you want to add new\nitems to an existing selection.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"selectAll"},children:[{type:"desc",attributes:{"text":"<p>Selects all items of the managed object.</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"selectRange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"begin"},children:[{type:"desc",attributes:{"text":"<p>Item to start with</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"end"},children:[{type:"desc",attributes:{"text":"<p>Item to end at</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Selects an item range between two given items.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDragSelection","fromProperty":"dragSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>dragSelection</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>dragSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dragSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setQuickSelection","fromProperty":"quickSelection"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>quickSelection</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>quickSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quickSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSelectionMode","fromProperty":"selectionMode"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>selectionMode</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>selectionMode</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selectionMode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleDragSelection","fromProperty":"dragSelection"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>dragSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dragSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleQuickSelection","fromProperty":"quickSelection"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>quickSelection</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #quickSelection}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"dragSelection","defaultValue":"false","propertyType":"new","apply":"_applyDragSelection","isMixin":"true","check":"Boolean"},children:[{type:"desc",attributes:{"text":"<p>Enable drag selection (multi selection of items through\ndragging the mouse in pressed states).</p>\n\n<p>Only possible for the selection modes <code>multi</code> and <code>additive</code></p>"}}]},{type:"property",attributes:{"name":"quickSelection","defaultValue":"false","propertyType":"new","apply":"_applyQuickSelection","isMixin":"true","check":"Boolean"},children:[{type:"desc",attributes:{"text":"<p>Enable quick selection mode, where no click is needed to change the selection.</p>\n\n<p>Only possible for the modes <code>single</code> and <code>one</code>.</p>"}}]},{type:"property",attributes:{"name":"selectionMode","defaultValue":"\"single\"","propertyType":"new","apply":"_applySelectionMode","possibleValues":"\"single\",\"multi\",\"additive\",\"one\"","isMixin":"true"},children:[{type:"desc",attributes:{"text":"<p>The selection mode to use.</p>\n\n<p>For further details please have a look at:\n{@link qx.ui.core.selection.Abstract#mode}</p>"}}]}]}]}