{type:"class",attributes:{"name":"MBlocker","packageName":"qx.ui.core","includer":"qx.ui.root.Abstract,qx.ui.window.Desktop","fullName":"qx.ui.core.MBlocker","type":"mixin"},children:[{type:"desc",attributes:{"text":"<p>This mixin blocks events and can be included into all widgets.</p>\n\n<p>The {@link #block} and {@link #unblock} methods provided by this mixin can be used\nto block any event from the widget. When blocked,\nthe blocker widget overlays the widget to block, including the padding area.</p>\n\n<p>The second set of methods ({@link #blockContent}, {@link #unblockContent})\ncan be used to block child widgets with a zIndex below a certain value.</p>"}},{type:"methods",children:[{type:"method",attributes:{"access":"private","isMixin":"true","name":"__createBlockerElement"},children:[{type:"desc",attributes:{"text":"<p>Creates the blocker element.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The blocker element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.MBlocker#blockerColor","isMixin":"true","name":"_applyBlockerColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Color"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>blockerColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyBlockerColor}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.MBlocker#blockerOpacity","isMixin":"true","name":"_applyBlockerOpacity"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>blockerOpacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyBlockerOpacity}.</p>"}}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_getBlocker"},children:[{type:"desc",attributes:{"text":"<p>Get/create the blocker element</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The blocker element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"access":"protected","isMixin":"true","name":"_getContentBlocker"},children:[{type:"desc",attributes:{"text":"<p>Get/create the content blocker element</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The blocker element</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.html.Element"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"block"},children:[{type:"desc",attributes:{"text":"<p>Block all events from this widget by placing a transparent overlay widget,\nwhich receives all events, exactly over the widget.</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"blockContent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"zIndex"},children:[{type:"desc",attributes:{"text":"<p>All child widgets with a zIndex below this value\n    will be blocked</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"zIndex"}}]}]}]},{type:"desc",attributes:{"text":"<p>Block direct child widgets with a zIndex below <code>zIndex</code></p>"}}]},{type:"method",attributes:{"name":"getBlockerColor","fromProperty":"blockerColor"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>blockerColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>blockerColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getBlockerOpacity","fromProperty":"blockerOpacity"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>blockerOpacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerOpacity}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>blockerOpacity</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initBlockerColor","fromProperty":"blockerColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>blockerColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>blockerColor</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initBlockerOpacity","fromProperty":"blockerOpacity"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>blockerOpacity</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>blockerOpacity</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerOpacity}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"isBlocked"},children:[{type:"desc",attributes:{"text":"<p>Returns whether the widget is blocked.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the widget is blocked.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"isContentBlocked"},children:[{type:"desc",attributes:{"text":"<p>Whether the content is blocked</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the content is blocked</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"resetBlockerColor","fromProperty":"blockerColor"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>blockerColor</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerColor}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetBlockerOpacity","fromProperty":"blockerOpacity"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>blockerOpacity</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerOpacity}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setBlockerColor","fromProperty":"blockerColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>blockerColor</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>blockerColor</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerColor}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setBlockerOpacity","fromProperty":"blockerOpacity"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>blockerOpacity</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>blockerOpacity</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #blockerOpacity}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"unblock"},children:[{type:"desc",attributes:{"text":"<p>Unblock the widget blocked by {@link #block}</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"unblockContent"},children:[{type:"desc",attributes:{"text":"<p>Remove the content blocker.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"blockerColor","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyBlockerColor","isMixin":"true","check":"Color","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Color of the blocker</p>"}}]},{type:"property",attributes:{"name":"blockerOpacity","defaultValue":"1","propertyType":"new","apply":"_applyBlockerOpacity","isMixin":"true","check":"Number","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Color of the blocker</p>"}}]}]}]}