{type:"class",attributes:{"isAbstract":"true","name":"LayoutItem","packageName":"qx.ui.core","superClass":"qx.core.Object","childClasses":"qx.ui.core.ColumnData,qx.ui.core.Spacer,qx.ui.core.Widget","fullName":"qx.ui.core.LayoutItem","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The base class of all items, which should be laid out using a layout manager\n{@link qx.ui.layout.Abstract}.</p>"}},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.LayoutItem#alignX","name":"_applyAlign"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>alignY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyAlign}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.LayoutItem#width","name":"_applyDimension"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>maxWidth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDimension}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.LayoutItem#marginTop","name":"_applyMargin"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>marginBottom</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyMargin}.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.core.LayoutItem#allowShrinkY","name":"_applyStretching"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>allowGrowX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyStretching}.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_computeSizeHint"},children:[{type:"desc",attributes:{"text":"<p>Computes the size hint of the layout item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The map with the preferred width/height and the allowed\n  minimum and maximum values.</p>"}}]}]},{type:"method",attributes:{"access":"protected","name":"_getHeightForWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>The computed width</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>If an item wants to trade height for width it has to implement this\nmethod and return the preferred height of the item if it is resized to\nthe given width. This function returns <code>null</code> if the item\ndo not support height for width.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The desired height</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_getRoot"},children:[{type:"desc",attributes:{"text":"<p>Returns the root item. The root item is the item which\nis directly inserted into an existing <span class=\"caps\">DOM</span> node at <span class=\"caps\">HTML</span> level.\nThis is often the <span class=\"caps\">BODY</span> element of a typical web page.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The root item (if available)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_hasHeightForWidth"},children:[{type:"desc",attributes:{"text":"<p>Whether the item supports height for width.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the item supports height for width</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"clearLayoutProperties"},children:[{type:"desc",attributes:{"text":"<p>Removes all stored layout properties.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"clearSeparators"},children:[{type:"desc",attributes:{"text":"<p>Reconfigure number of separators</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"clone"}},{type:"method",attributes:{"name":"getAlignX","fromProperty":"alignX"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>alignX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #alignX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>alignX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAlignY","fromProperty":"alignY"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>alignY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #alignY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>alignY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowGrowX","fromProperty":"allowGrowX"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowGrowX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowGrowX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowGrowY","fromProperty":"allowGrowY"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowGrowY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowGrowY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowShrinkX","fromProperty":"allowShrinkX"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowShrinkX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowShrinkX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAllowShrinkY","fromProperty":"allowShrinkY"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>allowShrinkY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>allowShrinkY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getApplicationRoot"},children:[{type:"desc",attributes:{"text":"<p>Returns the application root</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The currently used root</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.root.Abstract"}}]}]}]},{type:"method",attributes:{"name":"getBounds"},children:[{type:"desc",attributes:{"text":"<p>Get the computed location and dimension as computed by\nthe layout manager.</p>\n\n<p>This function is guaranteed to return a correct value\nduring a {@link #changeSize} or {@link #changePosition} event dispatch.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The location and dimensions in pixel\n   (if the layout is valid). Contains the keys\n   <code>width</code>, <code>height</code>, <code>left</code> and\n   <code>top</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getHeight","fromProperty":"height"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>height</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #height}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getLayoutParent"},children:[{type:"desc",attributes:{"text":"<p>Get the items parent. Even if the item has been added to a\nlayout, the parent is always a child of the containing item. The parent\nitem may be <code>null</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The parent.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"method",attributes:{"name":"getLayoutProperties"},children:[{type:"desc",attributes:{"text":"<p>Returns currently stored layout properties</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns a map of layout properties</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getMarginBottom","fromProperty":"marginBottom"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>marginBottom</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginBottom}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>marginBottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMarginLeft","fromProperty":"marginLeft"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>marginLeft</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginLeft}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>marginLeft</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMarginRight","fromProperty":"marginRight"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>marginRight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginRight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>marginRight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMarginTop","fromProperty":"marginTop"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>marginTop</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginTop}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>marginTop</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMaxHeight","fromProperty":"maxHeight"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>maxHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>maxHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMaxWidth","fromProperty":"maxWidth"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>maxWidth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxWidth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>maxWidth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMinHeight","fromProperty":"minHeight"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>minHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>minHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMinWidth","fromProperty":"minWidth"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>minWidth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minWidth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>minWidth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSizeHint"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"true","name":"compute"},children:[{type:"desc",attributes:{"text":"<p>Automatically compute size hint if currently not\n  cached?</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>A size hint computes the dimensions of a widget. It returns\nthe recommended dimensions as well as the min and max dimensions.\nThe min and max values already respect the stretching properties.</p>\n\n<h3>Wording</h3>\n<ul>\n<li>User value: Value defined by the widget user, using the size properties</li>\n\n<li>Layout value: The value computed by {@link #_getContentHint}</li>\n</ul>\n\n<h3>Algorithm</h3>\n<ul>\n<li>minSize: If the user min size is not null, the user value is taken,\n    otherwise the layout value is used.</li>\n\n<li>(preferred) size: If the user value is not null the user value is used,\n    otherwise the layout value is used.</li>\n\n<li>max size: Same as the preferred size.</li>\n</ul>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The map with the preferred width/height and the allowed\n  minimum and maximum values in cases where shrinking or growing\n  is required.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getWidth","fromProperty":"width"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>width</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #width}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>width</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"hasUserBounds"},children:[{type:"desc",attributes:{"text":"<p>Whether user bounds are set on this layout item</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether user bounds are set on this layout item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"hasValidLayout"},children:[{type:"desc",attributes:{"text":"<p>Whether the layout of this item (to layout the children)\nis valid.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAlignX","fromProperty":"alignX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>alignX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>alignX</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #alignX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAlignY","fromProperty":"alignY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>alignY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>alignY</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #alignY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowGrowX","fromProperty":"allowGrowX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowGrowX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowGrowX</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowGrowY","fromProperty":"allowGrowY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowGrowY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowGrowY</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowShrinkX","fromProperty":"allowShrinkX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowShrinkX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowShrinkX</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAllowShrinkY","fromProperty":"allowShrinkY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>allowShrinkY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>allowShrinkY</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initHeight","fromProperty":"height"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>height</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #height}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMarginBottom","fromProperty":"marginBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>marginBottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>marginBottom</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #marginBottom}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMarginLeft","fromProperty":"marginLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>marginLeft</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>marginLeft</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #marginLeft}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMarginRight","fromProperty":"marginRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>marginRight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>marginRight</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #marginRight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMarginTop","fromProperty":"marginTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>marginTop</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>marginTop</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #marginTop}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMaxHeight","fromProperty":"maxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>maxHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>maxHeight</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #maxHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMaxWidth","fromProperty":"maxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>maxWidth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>maxWidth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #maxWidth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMinHeight","fromProperty":"minHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>minHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>minHeight</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #minHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMinWidth","fromProperty":"minWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>minWidth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>minWidth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #minWidth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initWidth","fromProperty":"width"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>width</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>width</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #width}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"invalidateLayoutCache"},children:[{type:"desc",attributes:{"text":"<p>Called by the layout manager to mark this item&#8217;s layout as invalid.\nThis function should clear all layout relevant caches.</p>"}}]},{type:"method",attributes:{"name":"isAllowGrowX","fromProperty":"allowGrowX"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowGrowX</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isAllowGrowY","fromProperty":"allowGrowY"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowGrowY</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isAllowShrinkX","fromProperty":"allowShrinkX"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowShrinkX</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isAllowShrinkY","fromProperty":"allowShrinkY"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>allowShrinkY</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isExcluded"},children:[{type:"desc",attributes:{"text":"<p>Wether the item should be excluded from the layout</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Should the item be excluded by the layout</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isRootWidget"},children:[{type:"desc",attributes:{"text":"<p>Whether the item is a root item and directly connected to\nthe <span class=\"caps\">DOM</span>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the item a root item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"renderLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"left"},children:[{type:"desc",attributes:{"text":"<p>Any integer value for the left position,\n  always in pixels</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"top"},children:[{type:"desc",attributes:{"text":"<p>Any integer value for the top position,\n  always in pixels</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>Any positive integer value for the width,\n  always in pixels</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"height"},children:[{type:"desc",attributes:{"text":"<p>Any positive integer value for the height,\n  always in pixels</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Used by the layout engine to apply coordinates and dimensions.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map of which layout sizes changed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"renderSeparator"},children:[{type:"params",children:[{type:"param",attributes:{"name":"separator"},children:[{type:"desc",attributes:{"text":"<p>The separator to render</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]},{type:"param",attributes:{"name":"bounds"},children:[{type:"desc",attributes:{"text":"<p>Contains the left and top coordinate and the width and height\n   of the separator to render.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Renders a separator between two children</p>"}}]},{type:"method",attributes:{"name":"resetAlignX","fromProperty":"alignX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>alignX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #alignX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAlignY","fromProperty":"alignY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>alignY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #alignY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowGrowX","fromProperty":"allowGrowX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowGrowX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowGrowY","fromProperty":"allowGrowY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowGrowY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowShrinkX","fromProperty":"allowShrinkX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowShrinkX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowShrinkY","fromProperty":"allowShrinkY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowShrinkY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowStretchX","fromProperty":"allowStretchX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowStretchX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowStretchX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAllowStretchY","fromProperty":"allowStretchY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>allowStretchY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #allowStretchY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetHeight","fromProperty":"height"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>height</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #height}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMargin","fromProperty":"margin"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>margin</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #margin}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMarginBottom","fromProperty":"marginBottom"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>marginBottom</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #marginBottom}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMarginLeft","fromProperty":"marginLeft"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>marginLeft</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #marginLeft}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMarginRight","fromProperty":"marginRight"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>marginRight</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #marginRight}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMarginTop","fromProperty":"marginTop"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>marginTop</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #marginTop}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMaxHeight","fromProperty":"maxHeight"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>maxHeight</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #maxHeight}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMaxWidth","fromProperty":"maxWidth"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>maxWidth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #maxWidth}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMinHeight","fromProperty":"minHeight"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>minHeight</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #minHeight}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMinWidth","fromProperty":"minWidth"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>minWidth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #minWidth}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetUserBounds"},children:[{type:"desc",attributes:{"text":"<p>Clear the user bounds. After this call the layout item is layouted by\nthe layout manager again.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetWidth","fromProperty":"width"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>width</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #width}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"scheduleLayoutUpdate"},children:[{type:"desc",attributes:{"text":"<p>Indicate that the item has layout changes and propagate this information\nup the item hierarchy.</p>"}}]},{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.core.Object","name":"serialize"}},{type:"method",attributes:{"name":"setAlignX","fromProperty":"alignX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>alignX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>alignX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #alignX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAlignY","fromProperty":"alignY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>alignY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>alignY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #alignY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowGrowX","fromProperty":"allowGrowX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowGrowX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowGrowX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowGrowY","fromProperty":"allowGrowY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowGrowY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowGrowY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowShrinkX","fromProperty":"allowShrinkX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowShrinkX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowShrinkX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowShrinkY","fromProperty":"allowShrinkY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>allowShrinkY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>allowShrinkY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAllowStretchX","fromProperty":"allowStretchX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"allowGrowX"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #allowGrowX}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"allowShrinkX"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #allowShrinkX}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the values of the property group <code>allowStretchX</code>.</p>\n\n<p>This setter supports a shorthand mode compatible with the way margins and paddins are set in <span class=\"caps\">CSS</span>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowStretchX}.</p>"}}]},{type:"method",attributes:{"name":"setAllowStretchY","fromProperty":"allowStretchY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"allowGrowY"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #allowGrowY}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"allowShrinkY"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #allowShrinkY}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the values of the property group <code>allowStretchY</code>.</p>\n\n<p>This setter supports a shorthand mode compatible with the way margins and paddins are set in <span class=\"caps\">CSS</span>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowStretchY}.</p>"}}]},{type:"method",attributes:{"name":"setHeight","fromProperty":"height"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>height</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>height</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #height}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setLayoutParent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"parent"},children:[{type:"desc",attributes:{"text":"<p>The new parent.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}},{type:"entry",attributes:{"type":"null"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set the parent</p>"}}]},{type:"method",attributes:{"name":"setLayoutProperties"},children:[{type:"params",children:[{type:"param",attributes:{"name":"props"},children:[{type:"desc",attributes:{"text":"<p>Incoming layout property data</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Stores the given layout properties</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setMargin","fromProperty":"margin"},children:[{type:"params",children:[{type:"param",attributes:{"name":"marginTop"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #marginTop}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"marginRight"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #marginRight}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"marginBottom"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #marginBottom}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"marginLeft"},children:[{type:"desc",attributes:{"text":"<p>Sets the value of the property {@link #marginLeft}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the values of the property group <code>margin</code>.</p>\n\n<p>This setter supports a shorthand mode compatible with the way margins and paddins are set in <span class=\"caps\">CSS</span>.</p>\n\n<p>For further details take a look at the property definition: {@link #margin}.</p>"}}]},{type:"method",attributes:{"name":"setMarginBottom","fromProperty":"marginBottom"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>marginBottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>marginBottom</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginBottom}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMarginLeft","fromProperty":"marginLeft"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>marginLeft</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>marginLeft</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginLeft}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMarginRight","fromProperty":"marginRight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>marginRight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>marginRight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginRight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMarginTop","fromProperty":"marginTop"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>marginTop</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>marginTop</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #marginTop}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMaxHeight","fromProperty":"maxHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>maxHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>maxHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMaxWidth","fromProperty":"maxWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>maxWidth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>maxWidth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #maxWidth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMinHeight","fromProperty":"minHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>minHeight</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>minHeight</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minHeight}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMinWidth","fromProperty":"minWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>minWidth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>minWidth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #minWidth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setUserBounds"},children:[{type:"params",children:[{type:"param",attributes:{"name":"left"},children:[{type:"desc",attributes:{"text":"<p>left position (relative to the parent)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"top"},children:[{type:"desc",attributes:{"text":"<p>top position (relative to the parent)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>width of the layout item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"height"},children:[{type:"desc",attributes:{"text":"<p>height of the layout item</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set user bounds of the widget. Widgets with user bounds are sized and\npositioned manually and are ignored by any layout manager.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setWidth","fromProperty":"width"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>width</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>width</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #width}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowGrowX","fromProperty":"allowGrowX"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowGrowX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowGrowY","fromProperty":"allowGrowY"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowGrowY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowGrowY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowShrinkX","fromProperty":"allowShrinkX"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowShrinkX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleAllowShrinkY","fromProperty":"allowShrinkY"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>allowShrinkY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #allowShrinkY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"updateLayoutProperties"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"props"},children:[{type:"desc",attributes:{"text":"<p>Optional map of known layout properties</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Should be executed on every change of layout properties.</p>\n\n<p>This also includes &#8220;virtual&#8221; layout properties like margin or align\nwhen they have an effect on the parent and not on the widget itself.</p>\n\n<p>This method is always executed on the parent not on the\nmodified widget itself.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"alignX","propertyType":"new","allowNull":"true","possibleValues":"\"left\",\"center\",\"right\"","apply":"_applyAlign","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Horizontal alignment of the item in the parent layout.</p>\n\n<p>Note: Item alignment is only supported by {@link LayoutItem} layouts where\nit would have a visual effect. Except for {@link Spacer}, which provides\nblank space for layouts, all classes that inherit {@link LayoutItem} support alignment.</p>"}}]},{type:"property",attributes:{"name":"alignY","propertyType":"new","allowNull":"true","possibleValues":"\"top\",\"middle\",\"bottom\",\"baseline\"","apply":"_applyAlign","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Vertical alignment of the item in the parent layout.</p>\n\n<p>Note: Item alignment is only supported by {@link LayoutItem} layouts where\nit would have a visual effect. Except for {@link Spacer}, which provides\nblank space for layouts, all classes that inherit {@link LayoutItem} support alignment.</p>"}}]},{type:"property",attributes:{"name":"allowGrowX","defaultValue":"true","propertyType":"new","apply":"_applyStretching","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Whether the item can grow horizontally.</p>"}}]},{type:"property",attributes:{"name":"allowGrowY","defaultValue":"true","propertyType":"new","apply":"_applyStretching","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Whether the item can grow vertically.</p>"}}]},{type:"property",attributes:{"name":"allowShrinkX","defaultValue":"true","propertyType":"new","apply":"_applyStretching","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Whether the item can shrink horizontally.</p>"}}]},{type:"property",attributes:{"name":"allowShrinkY","defaultValue":"true","propertyType":"new","apply":"_applyStretching","check":"Boolean","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Whether the item can shrink vertically.</p>"}}]},{type:"property",attributes:{"mode":"shorthand","group":"\"allowGrowX\",\"allowShrinkX\"","name":"allowStretchX","themeable":"true","propertyType":"group"},children:[{type:"desc",attributes:{"text":"<p>Growing and shrinking in the horizontal direction</p>"}}]},{type:"property",attributes:{"mode":"shorthand","group":"\"allowGrowY\",\"allowShrinkY\"","name":"allowStretchY","themeable":"true","propertyType":"group"},children:[{type:"desc",attributes:{"text":"<p>Growing and shrinking in the vertical direction</p>"}}]},{type:"property",attributes:{"name":"height","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyDimension","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The item&#8217;s preferred height.</p>\n\n<p>The computed height may differ from the given height due to\nstretching. Also take a look at the related properties\n{@link #minHeight} and {@link #maxHeight}.</p>"}}]},{type:"property",attributes:{"mode":"shorthand","group":"\"marginTop\",\"marginRight\",\"marginBottom\",\"marginLeft\"","name":"margin","themeable":"true","propertyType":"group"},children:[{type:"desc",attributes:{"text":"<p>The &#8216;margin&#8217; property is a shorthand property for setting &#8216;marginTop&#8217;,\n&#8216;marginRight&#8217;, &#8216;marginBottom&#8217; and &#8216;marginLeft&#8217; at the same time.</p>\n\n<p>If four values are specified they apply to top, right, bottom and left respectively.\nIf there is only one value, it applies to all sides, if there are two or three,\nthe missing values are taken from the opposite side.</p>"}}]},{type:"property",attributes:{"name":"marginBottom","defaultValue":"0","propertyType":"new","apply":"_applyMargin","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (bottom)</p>"}}]},{type:"property",attributes:{"name":"marginLeft","defaultValue":"0","propertyType":"new","apply":"_applyMargin","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (left)</p>"}}]},{type:"property",attributes:{"name":"marginRight","defaultValue":"0","propertyType":"new","apply":"_applyMargin","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (right)</p>"}}]},{type:"property",attributes:{"name":"marginTop","defaultValue":"0","propertyType":"new","apply":"_applyMargin","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>Margin of the widget (top)</p>"}}]},{type:"property",attributes:{"name":"maxHeight","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyDimension","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The user provided maximum height.</p>\n\n<p>Also take a look at the related properties {@link #height} and {@link #minHeight}.</p>"}}]},{type:"property",attributes:{"name":"maxWidth","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyDimension","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The user provided maximal width.</p>\n\n<p>Also take a look at the related properties {@link #width} and {@link #minWidth}.</p>"}}]},{type:"property",attributes:{"name":"minHeight","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyDimension","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The user provided minimal height.</p>\n\n<p>Also take a look at the related properties {@link #height} and {@link #maxHeight}.</p>"}}]},{type:"property",attributes:{"name":"minWidth","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyDimension","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The user provided minimal width.</p>\n\n<p>Also take a look at the related properties {@link #width} and {@link #maxWidth}.</p>"}}]},{type:"property",attributes:{"name":"width","defaultValue":"null","allowNull":"true","propertyType":"new","apply":"_applyDimension","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The item&#8217;s preferred width.</p>\n\n<p>The computed width may differ from the given width due to\nstretching. Also take a look at the related properties\n{@link #minWidth} and {@link #maxWidth}.</p>"}}]}]}]}