{type:"class",attributes:{"isStatic":"true","name":"ImageLoader","packageName":"qx.io2","fullName":"qx.io2.ImageLoader","type":"bootstrap"},children:[{type:"desc",attributes:{"text":"<p>The ImageLoader can preload and manage loaded image resources. It easily\nhandles multiple requests and support callbacks for successful and failed\nrequests.</p>\n\n<p>After loading of an image the dimension of the image is stored as long\nas the application is running. This is quite useful for in-memory layouting.</p>\n\n<p>Use {@link #load} to preload your own images.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__onload"},children:[{type:"params",children:[{type:"param",attributes:{"name":"event"},children:[{type:"desc",attributes:{"text":"<p>Native event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]},{type:"param",attributes:{"name":"element"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span> element which represents the image</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]},{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>The image source loaded</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Internal event listener for all load/error events.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getHeight"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the image height</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The height or <code>null</code> when the image is not loaded</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getSize"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the size of a previously loaded image</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The dimension of the image. If the image is not yet loaded,\n   the dimensions are given as nullxnull pixel.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getWidth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the image width</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The width or <code>null</code> when the image is not loaded</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"isFailed"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given image has previously been requested using the\n{@link #load} method but failed.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the image loading failed"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"isLoaded"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given image has previously been loaded using the\n{@link #load} method.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the image is loaded"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"isLoading"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the given image is currently loading.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>true</code> when the image is loading in the moment."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"load"},children:[{type:"params",children:[{type:"param",attributes:{"name":"source"},children:[{type:"desc",attributes:{"text":"<p>Image source to load</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"callback"},children:[{type:"desc",attributes:{"text":"<p>Callback function to execute</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"context"},children:[{type:"desc",attributes:{"text":"<p>Context in which the given callback should be executed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"desc",attributes:{"text":"<p>Loads the given image. Supports a callback which is\nexecuted when the image is loaded.</p>\n\n<p>This method works asychronous.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}