{type:"class",attributes:{"name":"HttpRequest","packageName":"qx.io2","superClass":"qx.core.Object","fullName":"qx.io2.HttpRequest","type":"class"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>A more comfortable <span class=\"caps\">HTTP</span> request object than the native one under\n{@link qx.bom.Request}.</p>\n\n<p>Converts the whole communication into a qooxdoo style class with\nreal properties. The class also fires events to allow easy access\nto status changes.</p>\n\n<p>Automatically adds a few <span class=\"caps\">HTTP</span> headers to requests depdending on\nthe configuration.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"url"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">URL</span> to load</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]}]}]},{type:"events",children:[{type:"event",attributes:{"name":"abort"},children:[{type:"desc",attributes:{"text":"<p>Fires when the request was aborted by the user.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"change"},children:[{type:"desc",attributes:{"text":"<p>Fires when the request change its state, data field contains the state.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"error"},children:[{type:"desc",attributes:{"text":"<p>Fires when the request was completed with an error.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"load"},children:[{type:"desc",attributes:{"text":"<p>Fires when the request was completed successfully.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]},{type:"event",attributes:{"name":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Fires when the request reached the timeout limit.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__onabort"},children:[{type:"desc",attributes:{"text":"<p>Internal timeout listener</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__onchange"},children:[{type:"desc",attributes:{"text":"<p>Internal change listener</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__onerror"},children:[{type:"desc",attributes:{"text":"<p>Internal timeout listener</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__onload"},children:[{type:"desc",attributes:{"text":"<p>Internal timeout listener</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__ontimeout"},children:[{type:"desc",attributes:{"text":"<p>Internal timeout listener</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"abort"},children:[{type:"desc",attributes:{"text":"<p>Aborts a running request</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getAllResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Returns complete set of headers (labels and values) as a string</p>\n\n<p>Should output something similar to the following text:</p>\n\n<p>Date: Sun, 24 Oct 2004 04:58:38 <span class=\"caps\">GMT</span>\nServer: Apache/1.3.31 (Unix)\nKeep-Alive: timeout=15, max=99\nConnection: Keep-Alive\nTransfer-Encoding: chunked\nContent-Type: text/plain; charset=utf-8</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>All headers</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getAsync","fromProperty":"async"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>async</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>async</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getAuth","fromProperty":"auth"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>auth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #auth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>auth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getCache","fromProperty":"cache"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>cache</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getData","fromProperty":"data"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>data</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMethod","fromProperty":"method"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>method</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getMime","fromProperty":"mime"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>mime</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #mime}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>mime</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getPassword","fromProperty":"password"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>password</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getReadyState"},children:[{type:"desc",attributes:{"text":"<p>Returns the current request state.</p>\n\n<ul>\n<li>0 = uninitialized</li>\n<li>1 = sending request</li>\n<li>2 = headers loaded</li>\n<li>3 = loading result</li>\n<li>4 = done</li>\n</ul>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Ready state of the request</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getRefresh","fromProperty":"refresh"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>refresh</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #refresh}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>refresh</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Label of the header entry</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the value of a given header label.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The value or <code>null</code> when not defined.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getResponseHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Name of the header label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the string value of a single header label</p>\n\n<p>Should output something similar to the following text:</p>\n\n<p>Content-Type: text/plain; charset=utf-8</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The selected header&#8217;s value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getResponseText"},children:[{type:"desc",attributes:{"text":"<p>Returns the (currently downloaded) response text.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>String version of data returned from server process</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getResponseXml"},children:[{type:"desc",attributes:{"text":"<p>Returns the <span class=\"caps\">XML</span> document of the response (only available if content in mimetype application/xml was send).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">DOM</span>-compatible document object of data returned from server process</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"name":"getStatusCode"},children:[{type:"desc",attributes:{"text":"<p>Returns the response status code.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Numeric code returned by server, such as 404 for &#8220;Not Found&#8221; or 200 for &#8220;OK&#8221;</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getStatusText"},children:[{type:"desc",attributes:{"text":"<p>Returns the response status text. This is the human readable version of {@link #getStatusCode}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>String message accompanying the status code</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getTimeout","fromProperty":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>timeout</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getUrl","fromProperty":"url"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>url</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getUsername","fromProperty":"username"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>username</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAsync","fromProperty":"async"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>async</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>async</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initAuth","fromProperty":"auth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>auth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>auth</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #auth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initCache","fromProperty":"cache"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>cache</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>cache</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initData","fromProperty":"data"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>data</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>data</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMethod","fromProperty":"method"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>method</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>method</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initMime","fromProperty":"mime"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>mime</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>mime</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #mime}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initPassword","fromProperty":"password"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>password</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>password</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initRefresh","fromProperty":"refresh"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>refresh</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>refresh</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #refresh}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initTimeout","fromProperty":"timeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>timeout</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>timeout</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initUrl","fromProperty":"url"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>url</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>url</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initUsername","fromProperty":"username"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>username</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>username</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isAsync","fromProperty":"async"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>async</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isCache","fromProperty":"cache"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>cache</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isNotModified"},children:[{type:"desc",attributes:{"text":"<p>Wether the currently running or finished request returns modified results.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the request contains modified results.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isRefresh","fromProperty":"refresh"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>refresh</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #refresh}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"isSuccessful"},children:[{type:"desc",attributes:{"text":"<p>Wether the currently running or finished request is successful.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the request is successful.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"removeRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Name of the header label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Deletes a header label which should be send previously.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAsync","fromProperty":"async"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>async</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetAuth","fromProperty":"auth"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>auth</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #auth}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetCache","fromProperty":"cache"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>cache</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetData","fromProperty":"data"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>data</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMethod","fromProperty":"method"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>method</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetMime","fromProperty":"mime"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>mime</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #mime}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetPassword","fromProperty":"password"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>password</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetRefresh","fromProperty":"refresh"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>refresh</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #refresh}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetTimeout","fromProperty":"timeout"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>timeout</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetUrl","fromProperty":"url"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>url</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetUsername","fromProperty":"username"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>username</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"send"},children:[{type:"desc",attributes:{"text":"<p>Sends the configured request</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setAsync","fromProperty":"async"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>async</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>async</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setAuth","fromProperty":"auth"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>auth</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>auth</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #auth}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setCache","fromProperty":"cache"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>cache</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setData","fromProperty":"data"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>data</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>data</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #data}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMethod","fromProperty":"method"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>method</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>method</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #method}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setMime","fromProperty":"mime"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>mime</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>mime</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #mime}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setPassword","fromProperty":"password"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>password</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>password</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #password}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setRefresh","fromProperty":"refresh"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>refresh</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>refresh</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #refresh}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"label"},children:[{type:"desc",attributes:{"text":"<p>Name of the header label</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Value of the header field</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Assigns a label/value pair to the header to be sent with a request</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setTimeout","fromProperty":"timeout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>timeout</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>timeout</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #timeout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setUrl","fromProperty":"url"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>url</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>url</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #url}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setUsername","fromProperty":"username"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>username</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>username</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #username}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleAsync","fromProperty":"async"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>async</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #async}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleCache","fromProperty":"cache"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>cache</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cache}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"toggleRefresh","fromProperty":"refresh"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>refresh</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #refresh}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Boolean","defaultValue":"true","name":"async","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Set the request to asynchronous.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"http\",\"basic\"","defaultValue":"\"http\"","name":"auth","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Authentification method to use.</p>"}}]},{type:"property",attributes:{"check":"Boolean","defaultValue":"false","name":"cache","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Setting the value to <i>false</i> adds a parameter &#8220;nocache&#8221; to the request\nwith a value of the current time. Setting the value to <i>false</i> removes\nthe parameter.</p>"}}]},{type:"property",attributes:{"allowNull":"true","name":"data","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Data which should be send to the server.</p>\n\n<p>Supported types:</p>\n\n<p>String => Encode data using <span class=\"caps\">UTF</span>-8 for transmission.</p>\n\n<p>Document => Serialize data into a namespace well-formed <span class=\"caps\">XML</span> document and\n  encoded using the encoding given by data.xmlEncoding, if specified, or\n  <span class=\"caps\">UTF</span>-8 otherwise. Or, if this fails because the Document cannot be\n  serialized act as if data is null.</p>"}}]},{type:"property",attributes:{"possibleValues":"\"GET\",\"POST\",\"PUT\",\"HEAD\",\"DELETE\",\"OPTIONS\"","defaultValue":"\"GET\"","name":"method","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Determines what type of request to issue (GET or <span class=\"caps\">POST</span>).</p>"}}]},{type:"property",attributes:{"possibleValues":"\"text/plain\",\"text/javascript\",\"application/json\",\"application/xml\",\"text/html\"","defaultValue":"\"text/plain\"","name":"mime","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Response mimetype</p>"}}]},{type:"property",attributes:{"check":"String","allowNull":"true","name":"password","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Password to use for <span class=\"caps\">HTTP</span> authentication.\nSet to <span class=\"caps\">NULL</span> if <span class=\"caps\">HTTP</span> authentication is not used.</p>"}}]},{type:"property",attributes:{"check":"Boolean","defaultValue":"false","name":"refresh","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Allow the request to be successful only if the response has changed since\nthe last request. This is done by checking the Last-Modified header. Default\nvalue is false, ignoring the header.</p>"}}]},{type:"property",attributes:{"check":"Integer","allowNull":"true","name":"timeout","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Number of millieseconds before the request is being timed out.</p>"}}]},{type:"property",attributes:{"check":"String","defaultValue":"\"\"","name":"url","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Target url to issue the request to.</p>"}}]},{type:"property",attributes:{"check":"String","allowNull":"true","name":"username","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Username to use for <span class=\"caps\">HTTP</span> authentication.\nSet to <span class=\"caps\">NULL</span> if <span class=\"caps\">HTTP</span> authentication is not used.</p>"}}]}]}]}