{type:"class",attributes:{"name":"XmlHttp","packageName":"qx.io.remote.transport","superClass":"qx.io.remote.transport.Abstract","fullName":"qx.io.remote.transport.XmlHttp","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Transports requests to a server using the native XmlHttpRequest object.</p>\n\n<p>This class should not be used directly by client programmers.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.io.remote.transport.Abstract","isCtor":"true","name":"ctor"}}]},{type:"methods-static",children:[{type:"method",attributes:{"access":"private","isStatic":"true","name":"__dummy"},children:[{type:"desc",attributes:{"text":"<p>Dummy function to use for onreadystatechange after disposal</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"createRequestObject"},children:[{type:"desc",attributes:{"text":"<p>Return a new XMLHttpRequest object suitable for the client browser.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>native XMLHttpRequest object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"isSupported"},children:[{type:"desc",attributes:{"text":"<p>Whether the transport type is supported by the client.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>supported or not</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.io.remote.transport.Abstract#state","overriddenFrom":"qx.io.remote.transport.Abstract","name":"_applyState"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Current value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>Previous value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Apply method for the &#8220;state&#8221; property.\nFires an event for each state value to inform the listeners.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onreadystatechange"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>native event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Listener method for change of the &#8220;readystate&#8221;.\nSets the internal state and informs the transport layer.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"failedLocally"},children:[{type:"desc",attributes:{"text":"<p>Force the transport into the failed state (&#8220;failed&#8221;).</p>\n\n<p>This method should be used only if the requests <span class=\"caps\">URI</span> was local\naccess. I.e. it started with &#8220;file://&#8221;.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getFetchedLength"},children:[{type:"desc",attributes:{"text":"<p>Returns the length of the content as fetched thus far</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Length of the response text.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getReadyState"},children:[{type:"desc",attributes:{"text":"<p>Get the ready state of this transports request.</p>\n\n<p>For qx.io.remote.transport.XmlHttp, ready state is a number between 1 to 4.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>ready state number</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"name":"getRequest"},children:[{type:"desc",attributes:{"text":"<p>Returns the native request object</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>native XmlHTTPRequest object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"name":"getResponseContent"},children:[{type:"desc",attributes:{"text":"<p>Returns the content of the response</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Response content if available</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"null"}},{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getResponseHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"},children:[{type:"desc",attributes:{"text":"<p>Response header name</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a specific header provided by the server upon sending a request,\nwith header name determined by the argument headerName.</p>\n\n<p>Only available at readyState 3 and 4 universally and in readyState 2\nin Gecko.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Response header value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Provides a hash of all response headers.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>hash of all response headers</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getResponseText"},children:[{type:"desc",attributes:{"text":"<p>Provides the response text from the request when available and null\notherwise.  By passing true as the &#8220;partial&#8221; parameter of this method,\nincomplete data will be made available to the caller.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Content of the response as string</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getResponseXml"},children:[{type:"desc",attributes:{"text":"<p>Provides the <span class=\"caps\">XML</span> provided by the response if any and null otherwise.  By\npassing true as the &#8220;partial&#8221; parameter of this method, incomplete data will\nbe made available to the caller.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Content of the response as <span class=\"caps\">XML</span></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getStatusCode"},children:[{type:"desc",attributes:{"text":"<p>Returns the current status code of the request if available or -1 if not.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>current status code</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"getStatusText"},children:[{type:"desc",attributes:{"text":"<p>Provides the status text for the current request if available and null\notherwise.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>current status code text</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getStringResponseHeaders"},children:[{type:"desc",attributes:{"text":"<p>Returns all response headers of the request.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>response headers</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"send"},children:[{type:"desc",attributes:{"text":"<p>Implementation for sending the request</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.io.remote.transport.Abstract","name":"setRequestHeader"},children:[{type:"params",children:[{type:"param",attributes:{"name":"vLabel"},children:[{type:"desc",attributes:{"text":"<p>Request header name</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"vValue"},children:[{type:"desc",attributes:{"text":"<p>Request header value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Set a request header to this transports request.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}